package the.bytecode.club.bytecodeviewer.malwarescanner.impl;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.malwarescanner.MalwareCodeScanner;
import the.bytecode.club.bytecodeviewer.malwarescanner.MalwareScan;
import the.bytecode.club.bytecodeviewer.malwarescanner.util.SearchableString;

import static the.bytecode.club.bytecodeviewer.Constants.nl;

/***************************************************************************
 * Bytecode Viewer (BCV) - Java & Android Reverse Engineering Suite        *
 * Copyright (C) 2014 Kalen 'Konloch' Kinloch - http://bytecodeviewer.com  *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

/**
 * Scans for method instructions containing java/lang/reflect
 *
 * @author Konloch
 * @author WaterWolf
 * @since 10/02/2011
 */
public class ReflectionScanner extends MalwareCodeScanner
{
	@Override
	public void scanFieldString(MalwareScan scan, ClassNode cn, FieldNode field, SearchableString string) { }
	
	@Override
	public void scanMethodString(MalwareScan scan, ClassNode cn, MethodNode method, SearchableString string) { }
	
	@Override
	public void scanMethodInstruction(MalwareScan scan, ClassNode cn, MethodNode method, AbstractInsnNode instruction)
	{
		if (instruction instanceof MethodInsnNode)
		{
			final MethodInsnNode min = (MethodInsnNode) instruction;
			if (min.owner.startsWith("java/lang/reflect"))
				foundMethod(scan, instructionToString(instruction) + " at " + methodToString(cn, method) + nl);
		}
	}
}
