/* Copyright (c) 2021-2023 hors<horsicq@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "dialoghexedit.h"

#include "ui_dialoghexedit.h"

DialogHexEdit::DialogHexEdit(QWidget *pParent) : XShortcutsDialog(pParent), ui(new Ui::DialogHexEdit)
{
    ui->setupUi(this);

    connect(ui->widgetHexEdit, SIGNAL(dataChanged(qint64, qint64)), this, SIGNAL(dataChanged(qint64, qint64)));
}

DialogHexEdit::~DialogHexEdit()
{
    delete ui;
}

void DialogHexEdit::setData(QIODevice *pDevice, qint64 nStartOffset)
{
    ui->widgetHexEdit->setData(pDevice, nStartOffset);
    ui->widgetHexEdit->setFocus();
}

void DialogHexEdit::setBackupDevice(QIODevice *pDevice)
{
    ui->widgetHexEdit->setBackupDevice(pDevice);
}

void DialogHexEdit::setGlobal(XShortcuts *pShortcuts, XOptions *pXOptions)
{
    ui->widgetHexEdit->setGlobal(pShortcuts, pXOptions);
    XShortcutsDialog::setGlobal(pShortcuts, pXOptions);
}

void DialogHexEdit::on_pushButtonClose_clicked()
{
    this->close();
}
