######################################################################
#
# 3155_utf8jp_by_utf8jp_RT_SBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x80\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x80\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x80\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x81\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x81\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x82\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x82\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x83\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x83\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x84\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x84\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x85\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x85\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x86\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x86\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x87\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x87\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x88\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x88\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x89\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x89\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x8F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x90\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x90\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x91\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x91\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x92\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x92\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x93\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x93\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x94\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x94\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x95\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x95\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x96\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x96\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x97\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x97\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x98\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x98\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x99\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x99\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\x9F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xA9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xAF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xB9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x80\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x80\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x80\xBF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x80\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x80\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x81\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x81\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x82\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x82\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x83\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x83\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x84\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x84\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x85\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x85\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x86\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x86\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x87\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x87\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x88\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x88\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x89\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x89\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x8F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x90\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x90\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x91\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x91\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x92\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x92\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x93\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x93\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x94\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x94\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x95\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x95\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x96\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x96\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x97\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x97\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x98\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x98\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x99\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x99\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\x9F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xA9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xAF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xB9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x81\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x81\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x81\xBF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x80\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x80\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x81\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x81\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x82\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x82\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x83\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x83\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x84\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x84\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x85\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x85\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x86\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x86\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x87\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x87\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x88\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x88\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x89\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x89\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x8F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x90\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x90\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x91\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x91\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x92\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x92\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x93\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x93\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x94\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x94\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x95\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x95\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x96\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x96\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x97\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x97\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x98\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x98\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x99\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x99\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\x9F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xA9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xAF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xB9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x82\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x82\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x82\xBF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x80\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x80\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x80\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x81\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x81\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x81\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x82\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x82\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x82\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x83\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x83\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x83\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x84\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x84\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x84\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x85\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x85\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x85\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x86\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x86\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x86\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x87\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x87\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x87\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x88\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x88\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x88\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x89\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x89\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x89\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x8A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x8B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x8C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x8D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x8E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x8F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x8F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x90\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x90\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x90\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x91\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x91\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x91\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x92\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x92\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x92\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x93\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x93\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x93\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x94\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x94\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x94\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x95\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x95\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x95\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x96\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x96\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x96\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x97\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x97\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x97\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x98\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x98\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x98\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x99\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x99\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x99\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9A\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x9A\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9A\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9B\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x9B\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9B\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9C\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x9C\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9C\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9D\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x9D\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9D\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9E\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x9E\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9E\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9F\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\x9F\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\x9F\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xA9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xA9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xAA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xAB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xAC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xAD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xAE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xAF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xAF\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB0\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB0\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB0\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB1\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB1\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB1\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB2\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB2\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB2\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB3\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB3\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB3\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB4\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB4\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB4\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB5\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB5\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB5\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB6\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB6\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB6\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB7\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB7\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB7\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB8\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB8\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB8\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB9\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xB9\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xB9\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBA\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xBA\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBA\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBB\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xBB\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBB\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBC\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xBC\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBC\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBD\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xBD\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBD\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBE\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xBE\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBE\xF3\xB0\x80\x80"],

        ["\xF3\xB0\x83\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBF\xF3\xB0\x80\x80"],
        ["\xF3\xB0\x83\xBF\xF3\xB0\x80\x80",'utf8jp','utf8jp',{'INPUT_LAYOUT'=>'SS'},"\xF3\xB0\x83\xBF\xF3\xB0\x80\x80"],

    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
