/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.logo;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.logo.LogoScanner;
import net.sourceforge.plantuml.logo.LogoToken;
import net.sourceforge.plantuml.logo.TurtleGraphicsPane;

public class TinyJavaLogo {
    private final LogoScanner scanner = new LogoScanner();
    private final TurtleGraphicsPane turtleGraphicsPane;
    private final Map<String, String> dictionary = new HashMap<String, String>();
    private HtmlColor penColor;

    public TinyJavaLogo(TurtleGraphicsPane turtleGraphicsPane) {
        this.turtleGraphicsPane = turtleGraphicsPane;
    }

    private void message(String string) {
    }

    private void error(String string) {
        this.turtleGraphicsPane.message("Error: " + string);
    }

    private void parseCommandBlock(int n) {
        LogoToken logoToken = this.scanner.getToken();
        block17: while (logoToken.kind != 256 && logoToken.kind != 257) {
            switch (logoToken.kind) {
                case 260: {
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind == 259 || logoToken.kind == 270) {
                        this.turtleGraphicsPane.forward(logoToken.value);
                        logoToken = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("FORWARD requires distance");
                    return;
                }
                case 261: {
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind == 259 || logoToken.kind == 270) {
                        this.turtleGraphicsPane.back(logoToken.value);
                        logoToken = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("BACK requires distance");
                    return;
                }
                case 262: {
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind == 259 || logoToken.kind == 270) {
                        this.turtleGraphicsPane.left(logoToken.value);
                        logoToken = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("LEFT requires turn angle");
                    return;
                }
                case 263: {
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind == 259 || logoToken.kind == 270) {
                        this.turtleGraphicsPane.right(logoToken.value);
                        logoToken = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("RIGHT requires turn angle");
                    return;
                }
                case 264: {
                    this.turtleGraphicsPane.penUp();
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 265: {
                    this.turtleGraphicsPane.penDown();
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 266: {
                    this.turtleGraphicsPane.hideTurtle();
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 267: {
                    this.turtleGraphicsPane.showTurtle();
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 268: {
                    this.turtleGraphicsPane.clearScreen();
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 269: {
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind != 270) {
                        this.error("REPEAT requires positive integer count");
                        return;
                    }
                    int n2 = logoToken.intValue;
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind != 91) {
                        this.error("REPEAT requires block in []");
                        return;
                    }
                    int n3 = this.scanner.getPosition();
                    while (n2-- > 0) {
                        this.scanner.setPosition(n3);
                        this.parseCommandBlock(n + 1);
                    }
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 271: {
                    logoToken = this.scanner.getToken();
                    if (logoToken.kind != 258) {
                        this.error("TO requires name for new definition");
                        return;
                    }
                    String string = logoToken.lexeme;
                    if (this.dictionary.get(string) == null) {
                        this.message("Defining new command " + string);
                    } else {
                        this.message("Redefining command " + string);
                    }
                    String string2 = this.scanner.getRestAsString();
                    this.dictionary.put(string, string2);
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 258: {
                    String string = logoToken.lexeme;
                    String string2 = this.dictionary.get(string);
                    if (string2 == null) {
                        this.error("Undefined command " + string);
                        return;
                    }
                    String string3 = this.scanner.getSourceString();
                    int n4 = this.scanner.getPosition();
                    this.scanner.setSourceString(string2);
                    this.parseCommandBlock(0);
                    this.scanner.setSourceString(string3);
                    this.scanner.setPosition(n4);
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 272: {
                    logoToken = this.scanner.getToken();
                    HtmlColor htmlColor = HtmlColorUtils.getColorIfValid(logoToken.lexeme);
                    if (htmlColor == null) {
                        this.error("Unrecognized color name");
                        return;
                    }
                    this.penColor = htmlColor;
                    this.turtleGraphicsPane.setPenColor(this.penColor);
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 91: {
                    logoToken = this.scanner.getToken();
                    continue block17;
                }
                case 93: {
                    if (n == 0) {
                        this.error("] without matching [");
                        logoToken = this.scanner.getToken();
                        return;
                    }
                    return;
                }
            }
            this.error("Unrecognized symbol in input");
            return;
        }
    }

    public void doCommandLine(String string) {
        this.message(string);
        this.scanner.setSourceString(string);
        this.parseCommandBlock(0);
    }
}

