#!/usr/bin/perl -w

use lib 't';
use Testdata;

use Test::More tests => 3*@ciphers*@padstyles + 1;

BEGIN { use_ok (Crypt::ECB, qw(encrypt decrypt)) }

my $plaintext = "0";

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };
	SKIP: {	skip "$cipher not installed", 3*@padstyles if $@;

		my $ks = $ecb->keysize || 56;
		my $xkey = substr($key, 0, $ks);
		$ecb->key($xkey);

		foreach my $padstyle (@padstyles)
		{
			$ecb->padding($padstyle);

			my $enc1 = $ecb->encrypt($plaintext);
			my $enc2 = encrypt($xkey, $cipher, $plaintext, $padstyle);
			ok($enc1 eq $enc2, "$cipher, $padstyle padding: encrypting '0' function style");

			my $dec1 = $ecb->decrypt($enc1);
			my $dec2 = decrypt($xkey, $cipher, $enc2, $padstyle);
			ok($dec1 eq $plaintext, "$cipher, $padstyle padding: decrypting '0' OO style");
			ok($dec2 eq $plaintext, "$cipher, $padstyle padding: decrypting '0' function style");
		}
	}
}
