use strict;
use warnings;
use feature qw(say);

use Regex::Object;
use Data::Dumper;

my $re = Regex::Object->new(regex  => qr/^\w{3}$/); # regex to match 3 letters words

print "matched\n" if $re->match('foo')->success;  # prints matched
print "matched\n" if $re->match('fooz')->success; # nothing

$re = Regex::Object->new(regex  => qr/(?<name>\w+?) (?<surname>\w+)/); # named captures

my $result1 = $re->match('John Doe');

say $result1->success;

say $result1->prematch;

say $result1->match;

say $result1->postmatch;

say $result1->last_paren_match;

say $result1->captures->[0];

my $result2 = $re->match('Fill Anselmo');

# The main goal - both results have different named captured hashes
if ($result2->success) {
    my $name    = $result2->named_captures->{name};
    my $surname = $result2->named_captures->{surname};

    print "Name: $name; Surname: $surname\n";
}

if ($result1->success) {
    my $name    = $result1->named_captures->{name};
    my $surname = $result1->named_captures->{surname};

    print "Name: $name; Surname: $surname\n";
}
