package IO::Iron::Applications::IronCache::Templates;

use 5.010_000;
use strict;
use warnings FATAL => 'all';

# Global creator
BEGIN {
    # No exports
}

# Global destructor
END {
}

# ABSTRACT: ironcache.pl command internals: functionality.

our $VERSION = '0.12'; # VERSION: generated by DZP::OurPkgVersion

my $LINEFEED = qq{\n};

sub _list_caches_template {
    return '[% FOREACH cache_name IN data.caches.keys.sort %]'
            . '[% cache_name %]' . $LINEFEED
            . '[% END %]'
            ;
}

sub _list_items_template {
    return "[% USE timestamp = date(format => '%Y-%B-%d') %][% FILTER format('%-30s') %]Cache[% END %][% FILTER format('%-20s') %]Item[% END %][% FILTER format('%-21s') %]expires[% END %][% IF instructions.show_value %]value[% END %]" . $LINEFEED
            . "[% FOREACH cache_name IN data.caches.keys.sort %]"
            . "[% cache = data.caches.item(cache_name) %]"
            . "[% IF cache.error %]"
            . "[% cache_name %]:[% cache.error %]" . $LINEFEED
            . "[% ELSE %]"
            . "[% FOREACH item_key IN cache.items.keys.sort %]"
            . "[% item = cache.items.item(item_key) %]"
            . "[% IF item.error %]"
            . "[% FILTER format('%-30s') %][% FILTER truncate(29) %][% cache_name %][% END %][% END %]"
            . "[% FILTER format('%-20s') %][% item_key %][% END %]"
            . "[% FILTER format('%-21s') %] [% END %]"
            . "[% item.error %]" . $LINEFEED
            . "[% ELSE %]"
            . "[% FILTER format('%-30s') %][% FILTER truncate(29) %][% cache_name %][% END %][% END %]"
            . "[% FILTER format('%-20s') %][% item_key %][% END %]"
            . "[% FILTER format('%-21s') %][% item.expires %][% END %]"
            . "[% IF instructions.show_value %][% item.value %][% END %]" . $LINEFEED
            . "[% END %][%# /IF item.error %]"
            . "[% END %][%# /FOREACH %]"
            . "[% END %][%# /IF cache.error %]"
            . "[% END %][%# /FOREACH %]"
            ;
}

sub _show_cache_template {
    return "[% USE timestamp = date(format => '%Y-%B-%d') %][% FILTER format('%-30s') %]Name[% END %][% FILTER format('%-25s') %]id[% END %][% FILTER format('%-5s') %]size[% END %][% FILTER format('%-6s') %]dsize[% END %][% FILTER format('%-12s') %]created[% END %]" . $LINEFEED
            . "[% FOREACH cache_name IN data.caches.keys.sort %]"
            . "[% FILTER format('%-30s') %][% FILTER truncate(29) %][% cache_name %][% END %][% END %]"
            . "[% FILTER format('%-25s') %][% data.caches.item(cache_name).id %][% END %]"
            . "[% FILTER format('%-5s') %][% data.caches.item(cache_name).size %][% END %]"
            . "[% FILTER format('%-6s') %][% data.caches.item(cache_name).data_size %][% END %]"
            . "[% FILTER format('%-12s') %][% timestamp.format(data.caches.item(cache_name).created_at) %][% END %]" . $LINEFEED
            . "[% END %]"
            ;
}

# Attn. These four functions which operate "simple" operations on items
# do not have anything to print, except get_item
# which only outputs the item's (or items') content.
sub _put_item_template {
    return '';
}

sub _increment_item_template {
    return '';
}

sub _delete_cache_template {
    return '';
}

sub _delete_item_template {
    return '';
}

sub _clear_cache_template {
    return '';
}

sub _get_item_template {
    return ""
            ;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::Iron::Applications::IronCache::Templates - ironcache.pl command internals: functionality.

=head1 VERSION

version 0.12

=head1 AUTHOR

Mikko Koivunalho <mikko.koivunalho AT iki.fi>

=head1 BUGS

Please report any bugs or feature requests to bug-io-iron-applications@rt.cpan.org or through the web interface at:
 http://rt.cpan.org/Public/Dist/Display.html?Name=IO-Iron-Applications

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
