# Generated by default/object.tt
package Paws::LookoutMetrics::Action;
  use Moose;
  has LambdaConfiguration => (is => 'ro', isa => 'Paws::LookoutMetrics::LambdaConfiguration');
  has SNSConfiguration => (is => 'ro', isa => 'Paws::LookoutMetrics::SNSConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::Action

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::Action object:

  $service_obj->Method(Att1 => { LambdaConfiguration => $value, ..., SNSConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::Action object:

  $result = $service_obj->Method(...);
  $result->Att1->LambdaConfiguration

=head1 DESCRIPTION

A configuration that specifies the action to perform when anomalies are
detected.

=head1 ATTRIBUTES


=head2 LambdaConfiguration => L<Paws::LookoutMetrics::LambdaConfiguration>

A configuration for an AWS Lambda channel.


=head2 SNSConfiguration => L<Paws::LookoutMetrics::SNSConfiguration>

A configuration for an Amazon SNS channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

