# Generated by default/object.tt
package Paws::MediaConvert::AutomatedEncodingSettings;
  use Moose;
  has AbrSettings => (is => 'ro', isa => 'Paws::MediaConvert::AutomatedAbrSettings', request_name => 'abrSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::AutomatedEncodingSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::AutomatedEncodingSettings object:

  $service_obj->Method(Att1 => { AbrSettings => $value, ..., AbrSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::AutomatedEncodingSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AbrSettings

=head1 DESCRIPTION

Use automated encoding to have MediaConvert choose your encoding
settings for you, based on characteristics of your input video.

=head1 ATTRIBUTES


=head2 AbrSettings => L<Paws::MediaConvert::AutomatedAbrSettings>

Use automated ABR to have MediaConvert set up the renditions in your
ABR package for you automatically, based on characteristics of your
input video. This feature optimizes video quality while minimizing the
overall size of your ABR package.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

