package WebService::Mattermost::V4::API::Resource::LDAP;

# ABSTRACT: Wrapped API methods for the LDAP API endpoints.

use Moo;

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

sub sync {
    my $self = shift;

    return $self->_post({
        endpoint => 'sync',
        view     => 'Status',
    });
}

sub test {
    my $self = shift;

    return $self->_post({
        endpoint => 'test',
        view     => 'Status',
    });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::LDAP - Wrapped API methods for the LDAP API endpoints.

=head1 VERSION

version 0.31

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'email@address.com',
        password     => 'passwordhere',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $ldap = $mm->api->ldap;

=head2 METHODS

=over 4

=item C<sync()>

    $ldap->sync;

=item C<test()>

    $ldap->test;

=back

=head1 SEE ALSO

=over 4

=item L<https://api.mattermost.com/#tag/LDAP>

Official "LDAP" API documentation.

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
