use strict;
use warnings;
use Test::More;
use UUID ();


UUID::generate_time(my $bin1);
ok 1, 'generate1';

UUID::generate_time(my $bin2);
ok 1, 'generate2';

isnt $bin1, $bin2, 'different';

UUID::copy($bin2, $bin1);
ok 1, 'copy';

ok !UUID::compare($bin1, $bin2), 'compare';

is $bin2, $bin1, 'same';

done_testing;
__END__

#### legacy

my ($save1, $save2);

# make sure we get back a null if src isnt sane
$bin1 = 'x';
UUID::copy( $bin2, $bin1 );
ok UUID::is_null( $bin2 );
$bin1 = 'another really really really long sting';
UUID::copy( $bin2, $bin1 );
ok UUID::is_null( $bin2 );

# sane copy
UUID::generate( $bin1 );
$bin2 = '1234567890123456';
UUID::copy( $bin2, $bin1 );
is UUID::compare( $bin1, $bin2 ), 0;

# make sure we get back the same scalar we passed in
$bin1 = '1234567890123456';
UUID::generate( $bin2 );
$save1 = \$bin2;
UUID::copy( $bin2, $bin1 );
$save2 = \$bin2;
is $save1, $save2;
is $$save1, $$save2;

done_testing;
