/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.CatalogRefElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

class CatalogRefElementParser
extends AbstractElementParser {
    private final CatalogBuilder parentCatalogBuilder;
    private final DatasetNodeBuilder parentDatasetNodeBuilder;
    private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
    private DatasetNodeElementParserHelper datasetNodeElementParserHelper;
    private CatalogRefBuilder selfBuilder;

    private CatalogRefElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
        super(elementName, reader, builderFactory);
        this.parentCatalogBuilder = parentCatalogBuilder;
        this.parentDatasetNodeBuilder = null;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
    }

    private CatalogRefElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
        super(elementName, reader, builderFactory);
        this.parentCatalogBuilder = null;
        this.parentDatasetNodeBuilder = parentDatasetNodeBuilder;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
    }

    CatalogRefBuilder getSelfBuilder() {
        return this.selfBuilder;
    }

    void parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute titleAtt = startElement.getAttributeByName(CatalogRefElementNames.CatalogRefElement_XlinkTitle);
        String title = titleAtt.getValue();
        Attribute hrefAtt = startElement.getAttributeByName(CatalogRefElementNames.CatalogRefElement_XlinkHref);
        String href = hrefAtt.getValue();
        URI hrefUri = null;
        try {
            hrefUri = new URI(href);
        }
        catch (URISyntaxException e) {
            this.log.error("parseElement(): Bad catalog base URI [" + href + "]: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Bad catalog base URI [" + href + "]: " + e.getMessage(), e);
        }
        if (this.parentCatalogBuilder != null) {
            this.selfBuilder = this.parentCatalogBuilder.addCatalogRef(title, hrefUri);
        } else if (this.parentDatasetNodeBuilder != null) {
            this.selfBuilder = this.parentDatasetNodeBuilder.addCatalogRef(title, hrefUri);
        } else {
            throw new ThreddsXmlParserException("");
        }
        this.datasetNodeElementParserHelper = new DatasetNodeElementParserHelper(this.parentDatasetNodeElementParserHelper, this.selfBuilder, this.builderFactory);
        this.datasetNodeElementParserHelper.parseStartElementIdAttribute(startElement);
        this.datasetNodeElementParserHelper.parseStartElementIdAuthorityAttribute(startElement);
    }

    void handleChildStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.datasetNodeElementParserHelper.handleBasicChildStartElement(startElement, this.reader, this.selfBuilder)) {
            return;
        }
        StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
    }

    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        this.datasetNodeElementParserHelper.postProcessingAfterEndElement();
        this.datasetNodeElementParserHelper.addFinalThreddsMetadataToDatasetNodeBuilder(this.selfBuilder);
        this.datasetNodeElementParserHelper.addFinalMetadataToDatasetNodeBuilder(this.selfBuilder);
    }

    static class Factory {
        private QName elementName = CatalogRefElementNames.CatalogRefElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        CatalogRefElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
            return new CatalogRefElementParser(this.elementName, reader, builderFactory, parentCatalogBuilder, parentDatasetNodeElementParserHelper);
        }

        CatalogRefElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper) {
            return new CatalogRefElementParser(this.elementName, reader, builderFactory, parentDatasetNodeBuilder, parentDatasetNodeElementParserHelper);
        }
    }
}

