/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.maltparser.core.config.ConfigurationDir;
import org.maltparser.core.config.ConfigurationRegistry;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureModel;
import org.maltparser.core.feature.spec.SpecificationModel;
import org.maltparser.core.feature.spec.SpecificationModels;
import org.maltparser.core.feature.system.FeatureEngine;

public class FeatureModelManager {
    protected SpecificationModels specModels = new SpecificationModels();
    protected FeatureEngine featureEngine;
    protected ConfigurationDir configDirectory;

    public FeatureModelManager(FeatureEngine engine, ConfigurationDir configDirectory) throws MaltChainedException {
        this.setConfigDirectory(configDirectory);
        this.setFeatureEngine(engine);
    }

    private URL findURL(String specModelFileName) throws MaltChainedException {
        URL url = null;
        File specFile = this.configDirectory.getFile(specModelFileName);
        if (specFile.exists()) {
            try {
                url = new URL("file:///" + specFile.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                throw new MaltChainedException("Malformed URL: " + specFile, e);
            }
        } else {
            url = this.configDirectory.getConfigFileEntryURL(specModelFileName);
        }
        return url;
    }

    public void loadSpecification(String specModelFileName) throws MaltChainedException {
        this.specModels.load(this.findURL(specModelFileName));
    }

    public void loadParSpecification(String specModelFileName, String markingStrategy, String coveredRoot) throws MaltChainedException {
        this.specModels.loadParReader(this.findURL(specModelFileName), markingStrategy, coveredRoot);
    }

    public FeatureModel getFeatureModel(String specModelURL, int specModelUrlIndex, ConfigurationRegistry registry) throws MaltChainedException {
        return new FeatureModel(this.specModels.getSpecificationModel(this.findURL(specModelURL), specModelUrlIndex), registry, this.featureEngine);
    }

    public FeatureModel getFeatureModel(String specModelURL, ConfigurationRegistry registry) throws MaltChainedException {
        return new FeatureModel(this.specModels.getSpecificationModel(this.findURL(specModelURL), 0), registry, this.featureEngine);
    }

    public FeatureModel getFeatureModel(SpecificationModel specModel, ConfigurationRegistry registry) throws MaltChainedException {
        return new FeatureModel(specModel, registry, this.featureEngine);
    }

    public SpecificationModels getSpecModels() {
        return this.specModels;
    }

    protected void setSpecModels(SpecificationModels specModel) {
        this.specModels = specModel;
    }

    public FeatureEngine getFeatureEngine() {
        return this.featureEngine;
    }

    public void setFeatureEngine(FeatureEngine featureEngine) {
        this.featureEngine = featureEngine;
    }

    public ConfigurationDir getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigDirectory(ConfigurationDir configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String toString() {
        return this.specModels.toString();
    }
}

