%
% $Id: ttctexagray.cls,v 1.1 2007/06/03 18:54:22 frank Exp $
%
%%
%% The LaTeX Companion, 2ed
%%
%% Example ``article'' class for use with the Companion examples.
%%
%% Copyright (C) 2004 Frank Mittelbach, Michel Goossens,
%%    Johannes Braams, David Carlisle, and Chris Rowley
%%
%% It may be distributed and/or modified under the conditions
%% of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%%
%% See http://www.latex-project.org/lppl.txt for details.
%%
%
\LoadClass[twoside]{article}


\RequirePackage[T1]{fontenc}

\RequirePackage{times}
\RequirePackage[scaled]{helvet}


\let\StartShownPreambleCommands\relax
\let\StopShownPreambleCommands\relax


\let\ps@origplain\ps@plain
\let\ps@plain\ps@empty % this class doesn't produces page numbers
                       % since this would make examples too big
                       % but if necessary there is origplain

\iffalse
  % Book version uses emtt, and restricts to two colors.
  \DeclareFontFamily{T1}{emtt}{\hyphenchar \font\m@ne}
  \DeclareFontShape{T1}{emtt}{m}{n}{
          <-9>    emtt8
          <9-10>  emtt9
          <10-12> emtt10
          <12->   emtt12
        }{}
  \DeclareFontShape{T1}{emtt}{m}{it}{
          <->     emitt10
        }{}
  \DeclareFontShape{T1}{emtt}{m}{sl}{
          <->     emsltt10
        }{}
  \DeclareFontShape{T1}{emtt}{m}{sc}{
          <->     emtcsc10
        }{}

  \renewcommand{\ttdefault}{emtt}
\else
  % Public version uses cmtt (ectt)
  \renewcommand{\ttdefault}{cmtt}
\fi

\AtBeginDocument{
\ifx\selectcolormodel\@undefined
\else
  \selectcolormodel{cmyk}
\fi
}

% For some images in the book we want to ensure that they come out in gray
% inside the book, we therefore change all the color operators. To get color
% output, run this example without the \special command below.


\AtBeginDocument{%
  \special{ps:
    /setcmykcolor { exch 0.11 mul add
                    exch 0.59 mul add
                    exch 0.3 mul add
                    dup 1 gt { pop 1 }  if neg 1 add setgray } def
    /setrgbcolor { 0.11 mul
                   exch 0.59 mul add
                   exch 0.3 mul add setgray } def
    /sethsbcolor { /b exch def /s exch def 6 mul dup cvi dup /i exch def sub /f exch def
                   /F [[0 1 f sub 1][f 0 1][1 0 1 f sub][1 f 0][1 f sub 1 0][0 1 f][0 1 1]] def
                   F i get { s mul neg 1 add b mul} forall
                   0.11 mul
                   exch 0.59 mul add
                   exch 0.3 mul add setgray } def
  }
}

\endinput

