unit PrETSub1;

{  Main subroutines for RaTeX's drafter.

   26 Oct 93 JCC  Correct new begin and end sub
      ...         Rewrite begin and end sub/sup for HPLJ support
   11 Feb 91 JCC  \page command
    4 Sep 90 JCC  Map characters on graphics output.
20-30 Aug 90 JCC  Modify to use graphics instead of downloaded font.
    6 Jun 90 JCC  Adjustable size for lines etc.
}

{$I etdirect.inc}            {Directives shared by all units}

interface

uses {RawUnit,} utils, ETSyms, prETdef1, prETprn1;

procedure ProcessFile     (var MyState : state);

implementation { ============ IMPLEMENTATION ======================= }

var
   Con: text;  { Used for messages to console.  Not redirectable. }

procedure ErrorMes (var Mystate: state; s: string);
   forward;

procedure Restart (var MyState : state);
   forward;

procedure FindMatching (var Line: LongString; IPos: integer; EndSym: char;
                        var EndPos:integer);
   forward;

procedure GetBlockSize (var MyState: state; var Line: LongString;
                        IPos: integer; EndSym: char;
                        var EndPos, VSizeUp, VSizeDown, HSize: integer);
   forward;

procedure SizeFrac (var MyState: state; var Line: LongString; IPos: integer;
                        var EndPos, NumU, NumD, NumH,
                            DenomU, DenomD, DenomH: integer);
   forward;

procedure ProcessLine (var MyState: state; var Line: LongString);
   forward;

procedure EndPage (var MyState: State);
   forward;

procedure StartPage (var MyState: State);
   forward;

procedure StartPrinter (var MyState: State);
   forward;

procedure FinishPrinter (var MyState: State);
   forward;

{ --------------------- }

procedure Spaces (var L: LongString; n: integer);
{ MACHINE DEPENDENT: L := string of n spaces. }
var i: integer;
begin
   if n > sizeof (L) -1 then n := sizeof (L) - 1;
   FillChar (L[1], n, ' ');
   L[0] := chr(n);
end;

function max (i,j: integer): integer;
   begin if i > j then max := i else max := j; end;

function min (i,j: integer): integer;
   begin if i < j then min := i else min := j; end;

procedure ErrorMes (var Mystate: state; s: string);
   begin writeln ('Error in line ', MyState.NumLine, ': ', s); end;

procedure StartPrinter (var MyState: State);
begin
   with MyState do begin
      write (Dest, PrtSignOn);
      LineDots := 0;
   end;
end;


procedure FinishPrinter (var MyState: State);
begin
   with MyState do begin
      EndPage (MyState);
      write (Dest, PrtSignOff);
   end;
end;

procedure PrtVMove (var MyState: State; V: integer);
{ Move printing down by V dots.
  Note use of real arithmetic: i/j is real when i and j are integers.
}
begin
   with MyState do begin
      if PrtAbs then begin
         LineDots := LineDots + V;
         PrtVDo (MyState.Dest, round((LineDots/VDPI)*PrtVDPI));
      end else begin
         V := Round ( (V / VDPI) * PrtVDPI);
         PrtVDo (MyState.Dest, V);
{???? OLD 0.5??      LineDots := LineDots + Round (0.5 + (V/PrtVDPI) * VDPI);}
         LineDots := LineDots + Round ((V/PrtVDPI) * VDPI);
      end;
   end;
end;

procedure PrtVAbs (var MyState: State; VTarg: integer);
   { Move printing height to VTarg dots below top of page.
     If too far alread, don't move.  }
begin
      if VTarg > MyState.LineDots then
         PrtVMove (MyState, VTarg - MyState.LineDots);
end;

procedure SetLM (var MyState: state);
var MyLine: LongString;
begin
   with MyState do
      if HPos < 0 then begin
         Spaces (MyLine, PODots div CW);
         write (Dest, MyLine);
         HPos := 0;   { Margin set.  }
      end;
end;

procedure PrintLine (var MyState: State; var Line: LongString);
    { Send Line to printer, with correct left margin and height. }
var
   i: integer;
begin
   with MyState do begin
      if Line <> '' then begin
         if HPos < 0 then SetLM (MyState);
         write (Dest, Line, cr);
      end;
      if InEq then
         PrtVMove (MyState, eqlh)
      else
         PrtVMove (MyState, lh);
      HPos := -1;    { Margin not set for next line. }
   end;
end;

procedure EndPage (var MyState: State);
   { Move to bottom of page, ready to start next, if not already there. }
var
   i: integer;
   MyLine: LongString;
begin
   with MyState do begin
      if LineDots <= 0 then
         { Nothing to do }
      else begin
       {  Let user know what is happening: }
         write (Con, '[', page, ']', cr);
         if op or ( (page = 1) and NumbPg1) then
            { No page number needed.  }
         else begin
            PrtVAbs (MyState, pldots-fmdots);
            Spaces (MyLine, (podots + rmdots div 2) div cw);
            write (dest, cr, MyLine, page, cr);
         end;
         write (Dest, cr, ff);
         page := page + 1;
         LineDots := 0;
         HPos := -1;       { Left margin not set. }
      end;
   end;
end;

procedure StartPage (var MyState: State);
begin
   EndPage (MyState);  { Ensure we are at end of page }
   PrtVAbs (MyState, MyState.mtdots);
end;

procedure StartLine (var MyState: State);
begin
   with MyState do begin
      if LineDots <= 0 then StartPage (MyState);
      if HPos < 0 then SetLM (MyState);
   end;
end;

procedure EndLine (var MyState: State);
begin
   with MyState do begin
      write (Dest, cr);
      if InEq then
         PrtVMove (MyState, eqlh)
      else
         PrtVMove (MyState, lh);
      HPos := -1;    { Margin not set for next line. }
      if LineDots >= pldots - mbdots then EndPage (MyState);
   end;
end;

procedure Restart (var MyState : state);
begin
   with Mystate do begin
      BraceLevel := 0;   { Outside any brace pairs.  }
      BraceType[0] := normal;
      NumLine := 0;
      InEq    := false;  { Not in displayed equation. }
      LineDots := 0;     { Before start of page  }
      Page := 1;         { Ready to start page 1 }
      HPos := -1;        { At left edge of paper; margin not set. }
   end;
end;

procedure FindMatching (var Line: LongString; IPos: integer; EndSym: char;
                        var EndPos:integer);
  { Starting at IPos, and skipping matched pairs, set EndPos to point to first
    character equal to EndSym.  Assume Line[IPos] points to matching begin.
    If EndSym is not found, then EndPos is set beyond end-of-line.
  }
  var c: char;
  begin           {FindMatching}
     {First character after start of block:}
     EndPos := IPos+1;
     while EndPos <= Length(Line) do begin
        { Investigate next character.  Set EndPos to next character.}
        c := Line[EndPos];
        if c = EndSym then
           exit
        else if c in [beginsub, beginsup, beginarg] then begin
           FindMatching (Line, EndPos, succ(c), EndPos);
           inc (EndPos);
        end else
           inc (EndPos);
     end;  {while}
  end;            {FindMatching}


procedure SizeFrac (var MyState: state; var Line: LongString; IPos: integer;
                        var EndPos, NumU, NumD, NumH,
                            DenomU, DenomD, DenomH: integer);
   { Assume IPos points to fraction begin.  Get Sizes.
     EndPos points to last character of fraction.
     NumU to DenomH are sizes of numerator and denominator -- see
     GetBlockSize.  }
   begin             {SizeFrac}
    { Defaults: }
      NumU := 0;
      NumD := 0;
      NumH := 0;
      DenomU := 0;
      DenomD := 0;
      DenomH := 0;

    { Find numerator: }
      inc (IPos);
      EndPos := IPos;
      if (IPos > Length(Line)) or (Line[IPos] <> beginarg) then begin
        { Unstarted fraction }
        ErrorMes (MyState,  'Unstarted fraction');
        exit;
      end;
      GetBlockSize (MyState, Line, IPos, endarg, EndPos, NumU, NumD, NumH);
      if EndPos > Length(Line) then begin
        { Unfinished numerator }
        ErrorMes (MyState,  'Unfinished numerator');
        exit;
      end;

    { Find denominator: }
      IPos := EndPos + 1;
      if (IPos > Length(Line)) or (Line[IPos] <> beginarg) then begin
        { No denominator }
        ErrorMes (MyState,  'No denominator');
        exit;
      end;
      GetBlockSize (MyState, Line, IPos, endarg, EndPos, DenomU, DenomD, DenomH);
      if EndPos > Length(Line) then begin
        { Unfinished denominator }
        ErrorMes (MyState,  'Unfinished denominator');
        exit;
      end;

   end;              {SizeFrac}

procedure GetBlockSize (var MyState: state; var Line: LongString;
                        IPos: integer; EndSym: char;
                        var EndPos, VSizeUp, VSizeDown, HSize: integer);
  {  Compute size of block starting at character IPos.
     Vertical size is relative to baseline, and in units of dots.
     Horizontal size is in units of characters.
     If EndSym is null then block is rest of line, else
        it is block starting at IPos and ending at 1st character equal
        to EndSym, after taking into account nested braces.
  }
  var c: char;
      EndNum, EndDen: integer;
      NumU, NumD, NumH, DenomU, DenomD, DenomH, TmpU, TmpD, TmpH: integer;
  begin             {GetBlockSize}
    VSizeUp := 0;
    VSizeDown := 0;
    HSize := 0;
    if (EndSym <> null) and (Length(Line) >= IPos) then begin
       FindMatching (Line, IPos, EndSym, EndPos);
       Inc (IPos);
       if EndPos > Length(Line) then
          { EndSym not found!  }
          EndPos := Length (Line);
    end else
       EndPos := Length(Line);

    while IPos <= EndPos do begin
       c := Line [IPos];
       if c > #31 then begin
          inc (HSize);
       end else begin
          case c of
             beginsup,beginsub: begin
                GetBlockSize (MyState, Line, IPos, succ(c),
                      IPos, TmpU, TmpD, TmpH);
                  inc (HSize, TmpH);
                  if c=beginsup then begin
                     VSizeUp := max (VSizeUp, TmpU+MyState.srdots);
                     VSizeDown := max (VSizeDown, TmpD-MyState.srdots)
                  end else if c=beginsub then begin
                     VSizeUp := max (VSizeUp, TmpU-MyState.srdots);
                     VSizeDown := max (VSizeDown, TmpD+MyState.srdots);
                 end;
               end;
             symbol: begin inc (IPos); inc (HSize); end;
             bksp: if HSize > 0 then dec (HSize);
             beginfrac: with MyState do begin
                   SizeFrac(MyState, Line, IPos,
                            IPos, NumU, NumD, NumH, DenomU, DenomD, DenomH);
                   if NoRevLF then begin
                     VSizeUp := max (VSizeUp, max(NumU, DenomU));
                     VSizeDown := max (VSizeDown, max(NumD, DenomD));
                     HSize := NumH + length(beginfrac) + length(Midfrac)
                                   + length(Endfrac);
                   end else begin
                     VSizeUp := max (VSizeUp, NumU+NumD+FracSep+Charht div 2);
                     VSizeDown := max (VSizeDown, DenomU+DenomD+FracSep+
                                                  Charht div 2);
                     HSize := HSize + max (1, max(NumH,DenomH));
                   end;
                end;
          end;
       end;
       inc (IPos);
    end;
  end;              {GetBlockSize}

procedure TranSym (var MyState: state;
                   var Line: LongString; var posn: integer);
   { Translate symbol.  Assume Line[Posn] is symbol character. }
var ReplStr: LongString;
    c: char;
    MyFont: fontptr;
begin
   if Posn >= length(Line) then exit;
   Posn := Posn + 2;
   c := Line[Posn-1];
   with MyState do begin
      if GreekGraphics and (GreekMapGr[c] <> #0) then begin
         MyFont := GreekGrFont;
         Move (MyFont^[ord(GreekMapGr[c])-31], ReplStr[1], GreekGrLen);
         ReplStr[0] := chr (GreekGrLen);
         ReplStr := GreekGrIntro + ReplStr;
      end else
        ReplStr := GreekMap[c];
   end;
   Replace (Line, Posn, Posn-2, 2, ReplStr);
   dec (Posn);
end;


{$R-}
procedure ProcessBlock (var MyState: state; var Line: LongString;
                        var Posn: integer; EndSym: char);
   procedure RemoveCh;
      begin Delete (Line, Posn, 1); Posn := Posn - 1; end;
   procedure HMove (n: integer);
     { Move printing n spaces to right. }
     var i: integer;
     begin
        if n < 0 then
           for i := 1 to -n do write (MyState.Dest, #8)
        else
           for i := 1 to n do write (MyState.Dest, ' ');
     end;
   procedure SendPartial;
      begin  {Send processed part of line}
         write (MyState.Dest, Copy(Line, 1, Posn));
         Delete (Line, 1, Posn);
         Posn := 0;
      end;
   procedure StartSub;
       { Start subscript.  Assume Line[Posn] = beginsub char.   }
      begin
         Posn := Posn + 1;
         Replace (Line, Posn, Posn-1, 1, MyState.BeginSub);
         dec (Posn);
         if MyState.PrtAbs then begin
            if Posn > 0 then SendPartial;
            PrtVMove (MyState, MyState.srdots);
         end;
      end;
   procedure FinishSub;
      { Start subscript.  Assume Line[Posn] = endsub char.   }
      begin
         Posn := Posn + 1;
         Replace (Line, Posn, Posn-1, 1, MyState.EndSub);
         dec (Posn);
         if MyState.PrtAbs then begin
            if Posn > 0 then SendPartial;
            PrtVMove (MyState, -MyState.srdots);
         end;
      end;
   procedure StartSup;
      { Start subscript.  Assume Line[Posn] = beginsup char.   }
      begin
         Posn := Posn + 1;
         Replace (Line, Posn, Posn-1, 1, MyState.BeginSup);
         dec (Posn);
         if MyState.PrtAbs then begin
            if Posn > 0 then SendPartial;
            PrtVMove (MyState, -MyState.srdots);
         end;
      end;
   procedure FinishSup;
      { Start subscript.  Assume Line[Posn] = beginsup char.   }
      begin
         Posn := Posn + 1;
         Replace (Line, Posn, Posn-1, 1, MyState.EndSup);
         dec (Posn);
         if MyState.PrtAbs then begin
            if Posn > 0 then SendPartial;
            PrtVMove (MyState, MyState.srdots);
         end;
      end;
   procedure DoFrac;
      var EndPos: integer;
          NumOfs, DenomOfs, HSize, NumU, NumD, NumH, DenomU, DenomD, DenomH: integer;
     begin             {DoFrac}
        SizeFrac (MyState, Line, Posn,
                  EndPos, NumU, NumD, NumH, DenomU, DenomD, DenomH);
        HSize := max (1, max(NumH,DenomH));
        NumOfs := (HSize - NumH) div 2;
        DenomOfs := (HSize - DenomH) div 2;
        RemoveCh; {Remove frac character}
        if Posn > 0 then SendPartial;
        with MyState do begin
           if NoRevLF then
              write (Dest, beginfrac)
           else begin
              PrtVMove (MyState, -NumD - fracsep - charht div 2);
              HMove (NumOfs);
           end;
           if (Posn < Length(Line)) and (Line[Posn+1]=beginarg) then
              ProcessBlock (MyState, Line, Posn, endarg);
           if Posn > 0 then SendPartial;
           if NoRevLF then
              write (Dest, midfrac)
           else begin
              PrtVMove (MyState, NumD + DenomU
                                 + 2 * fracsep + 2 * (charht div 2));
              HMove (DenomOfs - NumOfs - NumH);
           end;
           if (Posn < Length(Line)) and (Line[Posn+1]=beginarg) then
              ProcessBlock (MyState, Line, Posn, endarg);
           if Posn > 0 then SendPartial;
           if NoRevLF then
              write (Dest, endfrac)
           else begin
              PrtVMove (MyState, - DenomU - fracsep - 2* (charht div 2));
              HMove (-DenomOfs - DenomH);
              write (Dest, BeginULine);
              HMove (HSize);
              write (Dest, EndULine);
              PrtVMove (MyState, charht div 2);
           end;
        end;
     end;              {Dofrac}
  var EndPos: integer;
      SaveLine: string;
  begin
    SendPartial;
    if (EndSym <> null) and (Length(Line) >= Posn) then begin
       FindMatching (Line, Posn+1, EndSym, EndPos);
       if EndPos > Length(Line) then
          { EndSym not found!  }
          EndPos := Length (Line);
      end else
         EndPos := Length(Line);
    SaveLine := Copy (Line, EndPos+1, Length(Line) - EndPos);
    Line[0] := chr(EndPos);
    while Posn < Length(Line) do begin
      { Assume Posn points to last character read.  }
      Posn := Posn + 1;
      if (line[Posn] > #126) or (line[Posn] < #32) then begin
         case line[Posn] of
            beginsup : StartSup;
            endsup   : FinishSup;
            beginsub : StartSub;
            endsub   : FinishSub;
            Symbol   : TranSym   (MyState, Line, Posn);
            bksp     : { Leave backspace as is };
            BeginMath, EndMath: RemoveCh;
            BeginEq: begin MyState.InEq := true; RemoveCh; end;
            EndEq:   begin MyState.InEq := false; RemoveCh; end;
            beginfrac:    Dofrac;
         else
            RemoveCh;  { Remove ctrl character so that it does not
                        confuse the printer.  }
         end;
         if Length(Line) > SizeOf(Line) - 40 then SendPartial;
      end;
    end;
    SendPartial;
    Line := SaveLine;
    Posn := 0;
  end;   {ProcessBlock}

procedure ProcessLine (var MyState: state; var Line: LongString);
   var
      Thislh, EndPos, VSizeUp, VSizeDown, HSize, Posn, ReplLen : integer;
begin      {ProcessLine}
   if (Line = '\page') then begin
      if (MyState.LineDots <= 0) then
         StartPage (MyState);
      EndPage (MyState);
      exit;
   end;
   Posn := 0;
   GetBlockSize (MyState, Line, 1, null, EndPos, VSizeUp, VSizeDown, HSize);
   with MyState do begin
      if InEq then
         Thislh := eqlh
      else
         Thislh := lh;
     { If not enough room on page and this isn't first line
       then start new page:}
      if (VSizeUp + VSizeDown + CharHt + LineDots > pldots - mbdots)
         and (LineDots > mtdots) then
         EndPage (MyState);
      { Make extra space if needed:}
      if VSizeUp > (Thislh - charht) div 2 then
         PrtVMove (MyState, VSizeUp - (Thislh - charht) div 2);
   end;
   StartLine (MyState);
   ProcessBlock (MyState, Line, Posn, null);
   write (MyState.Dest, Line);
   { Make extra space if needed:}
   if VSizeDown > (Thislh - MyState.charht) div 2 then
      PrtVMove (MyState, VSizeDown - (Thislh - MyState.charht) div 2);
   EndLine (MyState)
end;       {ProcessLine}
{$R+}

procedure ProcessFile  (var MyState : state);
var
   Line : LongString;
   SourceBuf, DestBuf : ^TextBuf;

begin
   assign (Con, CONNAME);
   rewrite(Con);
   with Mystate do begin
      if GraphSwitchPoss then
         case UseGraph of
            GrDef: GreekGraphics := ThisGraphDef;
            GrYes: GreekGraphics := true;
            GrNo:  GreekGraphics := false;
         end;
      if openr (Source, SourceName) <> 0 then begin
         writeln ('Cannot open input file ''', SourceName, '''.');
         exit;
      end;
      if openw (Dest, DestName) <> 0 then begin
         writeln ('Cannot open output device ''', DestName, '''.');
         exit;
      end;
      Raw (Dest);

      New (SourceBuf);
      if SourceBuf <> nil then SetTextBuf (Source, SourceBuf^);
      New (DestBuf);
      if DestBuf <> nil then SetTextBuf (Dest, DestBuf^);

      Restart (MyState);
      StartPrinter (MyState);
      while not eof(Source) do begin
         ReadLn (Source, Line);
         NumLine := Numline + 1;
         ProcessLine (MyState, Line);
      end;
      EndPage (MyState);
      FinishPrinter (MyState);
      close (Dest);
      close (Source);
      writeln (Con);
      if SourceBuf <> nil then Dispose (SourceBuf);
      if DestBuf <> nil then Dispose (DestBuf);
      writeln ('FINISHED: ', NumLine, ' lines processed.', Bell);
   end;
   close (Con);
end;

{ ==================== INITIALIZATION ============================  }
begin
end.

