#ifndef RUNTEX_H
#define RUNTEX_H
/* Library declarations */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <process.h>
#include <sys/stat.h>
#include <sys/param.h>
/* headers that may be included by one of the above */
#include <sys/types.h>
#include <limits.h>
#include <io.h>
#include <time.h>

/* helper macro to convert tokens to string */
#define cnv(s) #s
#define xcnv(s) cnv(s)

/* include it to get some definitions: Name and version to be exact */
#include "runtex.rch"

#define new_pointer(type,name)\
	name=(type*)malloc(sizeof(type))

#define new_array(type,name,size)\
	name=(type*)malloc((size)*sizeof(type))

#define new_string(name,size)\
	name=(char*)malloc((size)+1)

#define free_if(pointer) if (pointer) free(pointer)

/* macros to make freeing easier, need to be enclosed in {} in
	such cases as "else free_if_pntr(pointer);" */
#define free_if_pntr(pointer)\
	if (pointer) {\
		free(pointer);\
		pointer=NULL;\
	}

#define free_pntr(pointer)\
	{free(pointer);\
	pointer=NULL;}

/* Guarantee value for MAX_PATH */
#ifndef MAX_PATH
	#ifndef PATH_MAX
		#define MAX_PATH 260
	#else
		#define MAX_PATH PATH_MAX
	#endif
#endif

#ifdef __WIN32__
	#define NATIVE_DIRSEP '\\'
	#define NATIVE_PATHSEP ';'
	#define get_true_path(str) _fullpath(NULL,str,MAX_PATH);
#else
	#define NATIVE_DIRSEP '/';
	#define NATIVE_PATHSEP ':'
	#define get_true_path(str) truename(str,NULL);
#endif

#ifndef EXIT_SUCCESS
	#define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
	#define EXIT_FAILURE 1
#endif

enum RUNTEX_UTILS
{
	_MAKE_INDEX,
	_MAKE_GLOSSARY,
	_BIBTEX,
	_METAPOST,
	_METAFONT,
	_REFRESH_FILE_DB,
/* just so it's easier to define the array */
	NUMBER_RUNTEX_UTILS
};

const char* ini_names_utils[NUMBER_RUNTEX_UTILS]=
{
	"idx", "glo", "bib", "mp", "mf", "refresh"
};


enum RUNTEX_TEX_VARIANTS
{/* returns 0 on success, 1 on failure */
	_TEX,
	_LATEX,
	_ETEX,
	_ELATEX,
	_PDFTEX,
	_PDFLATEX,
	_PDFETEX,
	_PDFELATEX,
/* just so it's easier to define the array */
	NUMBER_RUNTEX_TEX_VARIANTS
};

/* exe names+switches+idx_type+3 localtexmf directories */
#define NUMBER_RUNTEX_INI_ENTRIES (NUMBER_RUNTEX_TEX_VARIANTS*2+NUMBER_RUNTEX_UTILS*2+4)

const char* ini_names_tex[NUMBER_RUNTEX_TEX_VARIANTS]=
{
	"t", "l", "e", "el", "p", "pl", "pe", "pel"
};


/* all variables needed */
typedef struct
{/* .ini file stuff */
	FILE* config_file;
	char* config_buffer;
/* strings of tex variant file names */
	char* tex[NUMBER_RUNTEX_TEX_VARIANTS];
	char* tex_opt[NUMBER_RUNTEX_TEX_VARIANTS];
/* strings of utilities file names */
	char* utils[NUMBER_RUNTEX_UTILS];
	char* utils_opt[NUMBER_RUNTEX_UTILS];
	int index_type;
/* dir of local TeX files */
	char* local_texmf;
/* subdir containing packages */
	char* local_packages;
/* subdir containing documentation for the packages */
	char* local_doc;
/* when install option is used move files from temp dir to
	subdir called local_texmf/local_packages/job_name */
	int tex_runs;
	int keep_temps;
	int exec_utils;
	int tex_variant;
	int install;
	int print_actions;
/* file to be processed as given by user; to be used for TeX runs */
	char* arg_name;
/* file to be worked on without suffix&path */
	char* job_name;
/* look for ini file and load it overriding settings
	search here for files related to tex file */
	char* job_dir;
} RUNTEX_DATA_STRUCT;

RUNTEX_DATA_STRUCT runtex_data;

void exit_on_error(const char* message, ...);

#endif
