/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.jolokia.server.core.config.ConfigExtractor;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.config.MapConfigExtractor;
import org.jolokia.server.core.config.SystemPropertyMode;
import org.jolokia.server.core.util.InetAddresses;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.server.core.util.StringUtil;

public class StaticConfiguration
implements Configuration {
    private Map<ConfigKey, String> environmentVariables;
    private Map<ConfigKey, String> systemProperties;
    private final Properties properties;
    private final SystemPropertyMode systemPropertyMode;
    private final Map<ConfigKey, String> configMap = new HashMap<ConfigKey, String>();
    private final Set<ConfigKey> keys = new HashSet<ConfigKey>();
    private final Map<String, String> networkConfig = new HashMap<String, String>();
    private boolean allowDnsReverseLookup;

    public StaticConfiguration(Object ... keyAndValues) {
        int idx;
        this.systemPropertyMode = SystemPropertyMode.FALLBACK;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)System.getProperties());
        this.allowDnsReverseLookup = false;
        for (int i = 0; i < keyAndValues.length; i += 2) {
            if (!ConfigKey.ALLOW_DNS_REVERSE_LOOKUP.equals(keyAndValues[i])) continue;
            this.allowDnsReverseLookup = Boolean.parseBoolean((String)keyAndValues[i + 1]);
            break;
        }
        this.initializeFromNetwork();
        for (int i = idx = 0; i < keyAndValues.length; i += 2) {
            this.configMap.put((ConfigKey)((Object)keyAndValues[i]), this.resolve((String)keyAndValues[i + 1]));
            this.keys.add((ConfigKey)((Object)keyAndValues[i]));
        }
        this.initializeFromEnvironment(null);
    }

    public StaticConfiguration(Map<String, String> pConfig) {
        this(pConfig, null, SystemPropertyMode.FALLBACK);
    }

    public StaticConfiguration(Map<String, String> pConfig, Map<String, String> pResolved, SystemPropertyMode pSystemPropertyMode) {
        this.systemPropertyMode = pSystemPropertyMode;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)System.getProperties());
        this.allowDnsReverseLookup = Boolean.parseBoolean(pConfig.getOrDefault(ConfigKey.ALLOW_DNS_REVERSE_LOOKUP.getKeyValue(), "false"));
        this.initializeFromNetwork();
        this.update(new MapConfigExtractor(pConfig), pResolved);
        if (this.systemPropertyMode != SystemPropertyMode.NEVER) {
            this.initializeFromEnvironment(pResolved);
        }
        if (pResolved != null) {
            pConfig.forEach((k, v) -> {
                if (!pResolved.containsKey(k)) {
                    pResolved.put((String)k, this.resolve((String)v));
                }
            });
        }
    }

    private void initializeFromNetwork() {
        NetworkInterface best = NetworkUtil.getBestMatchNetworkInterface();
        Map<String, InetAddresses> config = NetworkUtil.getBestMatchAddresses();
        config.forEach((name, addresses) -> {
            if (NetworkUtil.isIPv6Supported() && addresses.getIa6().isPresent()) {
                int percent;
                Inet6Address ia6 = addresses.getIa6().get();
                String ip6Address = ia6.getHostAddress();
                if ((ia6.getScopedInterface() != null || ia6.getScopeId() > 0) && (percent = ip6Address.indexOf(37)) != -1) {
                    ip6Address = ip6Address.substring(0, percent);
                }
                if (best != null && name.equals(best.getName())) {
                    this.networkConfig.put("ip6", ip6Address);
                    this.networkConfig.put("host6", this.allowDnsReverseLookup ? ia6.getHostName() : ip6Address);
                }
                this.networkConfig.put("ip6:" + name, ip6Address);
                this.networkConfig.put("host6:" + name, this.allowDnsReverseLookup ? ia6.getHostName() : ip6Address);
            }
            if (addresses.getIa4().isPresent()) {
                Inet4Address ia4 = addresses.getIa4().get();
                if (best != null && name.equals(best.getName())) {
                    this.networkConfig.put("ip", ia4.getHostAddress());
                    this.networkConfig.put("host", this.allowDnsReverseLookup ? ia4.getHostName() : ia4.getHostAddress());
                }
                this.networkConfig.put("ip:" + name, ia4.getHostAddress());
                this.networkConfig.put("host:" + name, this.allowDnsReverseLookup ? ia4.getHostName() : ia4.getHostAddress());
            }
        });
        this.properties.putAll(this.networkConfig);
    }

    private void initializeFromEnvironment(Map<String, String> pResolved) {
        this.environmentVariables = new HashMap<ConfigKey, String>();
        HashMap<String, String> env = new HashMap<String, String>(this.env());
        this.systemProperties = new HashMap<ConfigKey, String>();
        HashMap<String, String> sys = new HashMap<String, String>();
        Properties p = this.sys();
        for (String key2 : p.stringPropertyNames()) {
            sys.put(key2, p.getProperty(key2));
        }
        for (ConfigKey c : ConfigKey.values()) {
            String sysKey;
            String envKey = c.asEnvVariable();
            if (env.containsKey(envKey)) {
                this.environmentVariables.put(c, (String)env.get(envKey));
                this.keys.add(c);
            }
            if (!sys.containsKey(sysKey = c.asSystemProperty())) continue;
            this.systemProperties.put(c, (String)sys.get(sysKey));
            this.keys.add(c);
        }
        this.update(new MapConfigExtractor(env, k -> k.startsWith("JOLOKIA_")), pResolved, ConfigKey::fromEnvVariableFormat);
        this.update(new MapConfigExtractor(sys, k -> k.startsWith("jolokia.")), pResolved, key -> key.substring("jolokia.".length()));
    }

    public String resolve(String value) {
        return StringUtil.resolvePlaceholders(value, this.sys(), this.env());
    }

    protected Map<String, String> env() {
        return System.getenv();
    }

    protected Properties sys() {
        return this.properties;
    }

    public void update(ConfigExtractor pExtractor) {
        this.update(pExtractor, null);
    }

    public void update(ConfigExtractor pExtractor, Map<String, String> pResolved) {
        this.update(pExtractor, pResolved, Function.identity());
    }

    private void update(ConfigExtractor pExtractor, Map<String, String> pResolved, Function<String, String> newKey) {
        Enumeration<String> e = pExtractor.getNames();
        while (e.hasMoreElements()) {
            String originalKey = e.nextElement();
            String changedKey = newKey.apply(originalKey);
            ConfigKey key = ConfigKey.getGlobalConfigKey(changedKey);
            String resolved = this.resolve(pExtractor.getParameter(originalKey));
            if (pResolved != null) {
                pResolved.put(changedKey, resolved);
            }
            if (key == null) continue;
            this.configMap.put(key, resolved);
            this.keys.add(key);
        }
    }

    @Override
    public String getConfig(ConfigKey pKey) {
        String v;
        if (this.systemPropertyMode == SystemPropertyMode.OVERRIDE) {
            v = this.systemProperties.get((Object)pKey);
            if (v != null) {
                return v;
            }
            v = this.environmentVariables.get((Object)pKey);
            if (v != null) {
                return v;
            }
        }
        if ((v = this.configMap.get((Object)pKey)) != null) {
            return v;
        }
        if (this.systemPropertyMode == SystemPropertyMode.FALLBACK) {
            v = this.systemProperties.get((Object)pKey);
            if (v != null) {
                return v;
            }
            v = this.environmentVariables.get((Object)pKey);
            if (v != null) {
                return v;
            }
        }
        return pKey.getDefaultValue();
    }

    @Override
    public Set<ConfigKey> getConfigKeys() {
        return this.keys;
    }

    @Override
    public boolean containsKey(ConfigKey pKey) {
        return this.keys.contains((Object)pKey);
    }
}

