/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageCache;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageReader;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionCounterImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.jboss.logging.Logger;

public final class PageSubscriptionImpl
implements PageSubscription {
    private static final Logger logger = Logger.getLogger(PageSubscriptionImpl.class);
    private static final PagedReference dummyPagedRef = new PagedReferenceImpl(null, null, null);
    private boolean empty = true;
    private final AtomicInteger scheduledCleanupCount = new AtomicInteger(0);
    private volatile boolean autoCleanup = true;
    private final StorageManager store;
    private final long cursorId;
    private Queue queue;
    private final boolean persistent;
    private final Filter filter;
    private final PagingStore pageStore;
    private final PageCursorProvider cursorProvider;
    private volatile PagePosition lastAckedPosition;
    private List<PagePosition> recoveredACK;
    private final SortedMap<Long, PageCursorInfo> consumedPages = new TreeMap<Long, PageCursorInfo>();
    private final PageSubscriptionCounter counter;
    private final ArtemisExecutor executor;
    private final AtomicLong deliveredCount = new AtomicLong(0L);
    private final AtomicLong deliveredSize = new AtomicLong(0L);
    private final ConcurrentLongHashMap<PageReader> pageReaders = new ConcurrentLongHashMap();

    public AtomicInteger getScheduledCleanupCount() {
        return this.scheduledCleanupCount;
    }

    PageSubscriptionImpl(PageCursorProvider cursorProvider, PagingStore pageStore, StorageManager store, ArtemisExecutor executor, Filter filter, long cursorId, boolean persistent) {
        this.pageStore = pageStore;
        this.store = store;
        this.cursorProvider = cursorProvider;
        this.cursorId = cursorId;
        this.executor = executor;
        this.filter = filter;
        this.persistent = persistent;
        this.counter = new PageSubscriptionCounterImpl(store, this, (Executor)executor, persistent, cursorId);
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pageStore;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public boolean isPaging() {
        return this.pageStore.isPaging();
    }

    @Override
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public void disableAutoCleanup() {
        this.autoCleanup = false;
    }

    @Override
    public void enableAutoCleanup() {
        this.autoCleanup = true;
    }

    public PageCursorProvider getProvider() {
        return this.cursorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notEmpty() {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.empty = false;
        }
    }

    @Override
    public void bookmark(PagePosition position) throws Exception {
        PageCursorInfo cursorInfo = this.getPageInfo(position);
        if (position.getMessageNr() > 0) {
            cursorInfo.confirmed.addAndGet(position.getMessageNr());
        }
        this.confirmPosition(position);
    }

    @Override
    public long getMessageCount() {
        if (this.empty) {
            return 0L;
        }
        return this.counter.getValue() - this.deliveredCount.get();
    }

    @Override
    public long getPersistentSize() {
        if (this.empty) {
            return 0L;
        }
        long messageSize = this.counter.getPersistentSize() - this.deliveredSize.get();
        return messageSize > 0L ? messageSize : 0L;
    }

    @Override
    public PageSubscriptionCounter getCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reloadPageCompletion(PagePosition position) throws Exception {
        if (!this.pageStore.checkPageFileExists((int)position.getPageNr())) {
            return false;
        }
        if (this.pageStore.getCurrentPage() != null && (long)this.pageStore.getCurrentPage().getPageId() == position.getPageNr()) {
            this.pageStore.forceAnotherPage();
        }
        PageCursorInfo info = new PageCursorInfo(position.getPageNr(), position.getMessageNr());
        info.setCompleteInfo(position);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.consumedPages.put(position.getPageNr(), info);
        }
        return true;
    }

    @Override
    public void scheduleCleanupCheck() {
        if (this.autoCleanup) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Scheduling cleanup", (Throwable)new Exception("trace"));
            }
            if (this.scheduledCleanupCount.get() > 2) {
                return;
            }
            this.scheduledCleanupCount.incrementAndGet();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PageSubscriptionImpl.this.autoCleanup) {
                            PageSubscriptionImpl.this.cleanupEntries(false);
                        }
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.problemCleaningCursorPages(e);
                    }
                    finally {
                        PageSubscriptionImpl.this.scheduledCleanupCount.decrementAndGet();
                    }
                }
            });
        }
    }

    @Override
    public void onPageModeCleared(Transaction tx) throws Exception {
        if (this.counter != null) {
            this.counter.delete(tx);
        }
        this.empty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupEntries(final boolean completeDelete) throws Exception {
        if (completeDelete) {
            this.counter.delete();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"cleanupEntries", (Throwable)new Exception("trace"));
        }
        TransactionImpl tx = new TransactionImpl(this.store);
        boolean persist = false;
        ArrayList<PageCursorInfo> completedPages = new ArrayList<PageCursorInfo>();
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            if (this.lastAckedPosition == null) {
                return;
            }
            for (Map.Entry<Long, PageCursorInfo> entry : this.consumedPages.entrySet()) {
                PageCursorInfo info = entry.getValue();
                if (!info.isDone() || info.isPendingDelete()) continue;
                Page currentPage = this.pageStore.getCurrentPage();
                if (currentPage != null && entry.getKey() == (long)this.pageStore.getCurrentPage().getPageId() && currentPage.isLive()) {
                    logger.trace((Object)("We can't clear page " + entry.getKey() + " now since it's the current page"));
                    continue;
                }
                info.setPendingDelete();
                completedPages.add(entry.getValue());
            }
        }
        for (PageCursorInfo infoPG : completedPages) {
            if (this.isPersistent()) {
                PagePositionImpl completePage = new PagePositionImpl(infoPG.getPageId(), infoPG.getNumberOfMessages());
                infoPG.setCompleteInfo(completePage);
                this.store.storePageCompleteTransactional(tx.getID(), this.getId(), completePage);
                if (!persist) {
                    persist = true;
                    tx.setContainsPersistent();
                }
            }
            for (PagePosition pos : infoPG.acks) {
                if (pos.getRecordID() < 0L) continue;
                this.store.deleteCursorAcknowledgeTransactional(tx.getID(), pos.getRecordID());
                if (persist) continue;
                tx.setContainsPersistent();
                persist = true;
            }
            infoPG.acks.clear();
            infoPG.acks = Collections.synchronizedSet(new LinkedHashSet());
            infoPG.removedReferences.clear();
            infoPG.removedReferences = (Set)new ConcurrentHashSet();
        }
        tx.addOperation(new TransactionOperationAbstract(){

            @Override
            public void afterCommit(Transaction tx1) {
                PageSubscriptionImpl.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!completeDelete) {
                            PageSubscriptionImpl.this.cursorProvider.scheduleCleanup();
                        }
                    }
                });
            }
        });
        tx.commit();
    }

    public String toString() {
        return "PageSubscriptionImpl [cursorId=" + this.cursorId + ", queue=" + this.queue + ", filter = " + this.filter + "]";
    }

    private PagedReference getReference(PagePosition pos) {
        PageReader pageReader = (PageReader)this.pageReaders.get(pos.getPageNr());
        PagedMessage pagedMessage = pageReader != null ? pageReader.getMessage(pos, true, false) : this.cursorProvider.getMessage(pos);
        return this.cursorProvider.newReference(pos, pagedMessage, this);
    }

    @Override
    public PageIterator iterator() {
        return new CursorIterator();
    }

    public PageIterator iterator(boolean browsing) {
        return new CursorIterator(browsing);
    }

    private PagedReference internalGetNext(PagePositionAndFileOffset pos) {
        PageReader pageReader;
        PagePosition retPos = pos.nextPagePostion();
        PageCache cache = null;
        while (!(retPos.getPageNr() > (long)this.pageStore.getCurrentWritingPage() || (cache = (pageReader = (PageReader)this.pageReaders.get(retPos.getPageNr())) == null ? this.cursorProvider.getPageCache(retPos.getPageNr()) : pageReader) != null && (cache.isLive() || retPos.getMessageNr() < cache.getNumberOfMessages() && cache.getNumberOfMessages() != 0))) {
            this.saveEmptyPageAsConsumedPage(cache);
            retPos = this.moveNextPage(retPos);
            cache = null;
        }
        if (cache != null) {
            PagedMessage serverMessage;
            if (cache instanceof PageReader) {
                serverMessage = ((PageReader)cache).getMessage(retPos, false, true);
                PageCache previousPageCache = (PageCache)this.pageReaders.putIfAbsent(retPos.getPageNr(), (Object)((PageReader)cache));
                if (previousPageCache != null && previousPageCache != cache) {
                    cache.close();
                }
            } else {
                serverMessage = cache.getMessage(retPos);
            }
            if (serverMessage != null) {
                return this.cursorProvider.newReference(retPos, serverMessage, this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagePosition moveNextPage(PagePosition pos) {
        PagePosition retPos = pos;
        PageReader pageReader = (PageReader)this.pageReaders.remove(pos.getPageNr());
        if (pageReader != null) {
            pageReader.close();
        }
        while (true) {
            retPos = retPos.nextPage();
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(retPos.getPageNr());
                if (pageInfo == null || !pageInfo.isPendingDelete() && pageInfo.getCompleteInfo() == null) {
                    return retPos;
                }
            }
        }
    }

    private boolean routed(PagedMessage message) {
        long id = this.getId();
        for (long qid : message.getQueueIDs()) {
            if (qid != id) continue;
            return true;
        }
        return false;
    }

    private synchronized PagePositionAndFileOffset getStartPosition() {
        return new PagePositionAndFileOffset(-1, new PagePositionImpl(this.pageStore.getFirstPage(), -1));
    }

    @Override
    public void confirmPosition(Transaction tx, PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledgeTransactional(tx.getID(), this.cursorId, position);
        }
        this.installTXCallback(tx, position);
    }

    private void confirmPosition(Transaction tx, PagePosition position, long persistentSize) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledgeTransactional(tx.getID(), this.cursorId, position);
        }
        this.installTXCallback(tx, position, persistentSize);
    }

    @Override
    public void ackTx(Transaction tx, PagedReference reference) throws Exception {
        long persistentSize = this.getPersistentSize(reference);
        this.confirmPosition(tx, reference.getPosition(), persistentSize);
        this.counter.increment(tx, -1, -persistentSize);
        PageTransactionInfo txInfo = this.getPageTransaction(reference);
        if (txInfo != null) {
            txInfo.storeUpdate(this.store, this.pageStore.getPagingManager(), tx);
        }
    }

    @Override
    public void ack(PagedReference reference) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.store);
        this.ackTx(tx, reference);
        tx.commit();
    }

    @Override
    public boolean contains(PagedReference ref) throws Exception {
        boolean routed = false;
        for (long idRef : ref.getPagedMessage().getQueueIDs()) {
            if (idRef != this.cursorId) continue;
            routed = true;
            break;
        }
        if (!routed) {
            return false;
        }
        return !this.getPageInfo(ref.getPosition()).isAck(ref.getPosition());
    }

    @Override
    public void confirmPosition(final PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledge(this.cursorId, position);
        }
        this.store.afterCompleteOperations(new IOCallback(){
            volatile String error = "";

            public void onError(int errorCode, String errorMessage) {
                this.error = " errorCode=" + errorCode + ", msg=" + errorMessage;
                ActiveMQServerLogger.LOGGER.pageSubscriptionError(this, this.error);
            }

            public void done() {
                PageSubscriptionImpl.this.processACK(position);
            }

            public String toString() {
                return IOCallback.class.getSimpleName() + "(" + PageSubscriptionImpl.class.getSimpleName() + ") " + this.error;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstPage() {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            if (this.empty && this.consumedPages.isEmpty()) {
                return -1L;
            }
            long lastPageSeen = 0L;
            for (Map.Entry<Long, PageCursorInfo> info : this.consumedPages.entrySet()) {
                lastPageSeen = info.getKey();
                if (info.getValue().isDone() || info.getValue().isPendingDelete()) continue;
                return info.getKey();
            }
            return lastPageSeen;
        }
    }

    @Override
    public void addPendingDelivery(PagePosition position) {
        PageCursorInfo info = this.getPageInfo(position);
        if (info != null) {
            info.incrementPendingTX();
        }
    }

    @Override
    public void removePendingDelivery(PagePosition position) {
        PageCursorInfo info = this.getPageInfo(position);
        if (info != null) {
            info.decrementPendingTX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeliver(PageIterator iterator, PagePosition position) {
        iterator.redeliver(position);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(position.getPageNr());
            if (pageInfo != null) {
                pageInfo.decrementPendingTX();
            }
        }
    }

    @Override
    public PagedMessage queryMessage(PagePosition pos) {
        PageReader pageReader = (PageReader)this.pageReaders.get(pos.getPageNr());
        if (pageReader != null) {
            return pageReader.getMessage(pos, true, false);
        }
        return this.cursorProvider.getMessage(pos);
    }

    @Override
    public void reloadACK(PagePosition position) {
        if (this.recoveredACK == null) {
            this.recoveredACK = new LinkedList<PagePosition>();
        }
        this.recoveredACK.add(position);
    }

    @Override
    public void reloadPreparedACK(Transaction tx, PagePosition position) {
        this.deliveredCount.incrementAndGet();
        this.installTXCallback(tx, position);
    }

    @Override
    public void positionIgnored(PagePosition position) {
        this.processACK(position);
    }

    @Override
    public void lateDeliveryRollback(PagePosition position) {
        PageCursorInfo cursorInfo = this.processACK(position);
        cursorInfo.decrementPendingTX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete(long page) {
        logger.tracef("%s isComplete %d", (Object)this, (Object)page);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            boolean isDone;
            if (this.empty && this.consumedPages.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("isComplete(%d)::Subscription %s has empty=%s, consumedPages.isEmpty=%s", new Object[]{page, this, this.empty, this.consumedPages.isEmpty()});
                }
                return true;
            }
            PageCursorInfo info = (PageCursorInfo)this.consumedPages.get(page);
            if (info == null && this.empty) {
                logger.tracef("isComplete(%d)::::Couldn't find info and it is empty", page);
                return true;
            }
            boolean bl = isDone = info != null && info.isDone();
            if (logger.isTraceEnabled()) {
                logger.tracef("isComplete(%d):: found info=%s, isDone=%s", (Object)page, (Object)info, (Object)isDone);
            }
            return isDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        long tx = this.store.generateID();
        try {
            boolean isPersistent = false;
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                for (PageCursorInfo cursor : this.consumedPages.values()) {
                    for (PagePosition info : cursor.acks) {
                        if (info.getRecordID() < 0L) continue;
                        isPersistent = true;
                        this.store.deleteCursorAcknowledgeTransactional(tx, info.getRecordID());
                    }
                    PagePosition completeInfo = cursor.getCompleteInfo();
                    if (completeInfo == null || completeInfo.getRecordID() < 0L) continue;
                    this.store.deletePageComplete(completeInfo.getRecordID());
                    cursor.setCompleteInfo(null);
                }
            }
            if (isPersistent) {
                this.store.commit(tx);
            }
            this.cursorProvider.close(this);
        }
        catch (Exception e) {
            try {
                this.store.rollback(tx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public long getId() {
        return this.cursorId;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void processReload() throws Exception {
        if (this.recoveredACK != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"********** processing reload!!!!!!!");
            }
            Collections.sort(this.recoveredACK);
            long txDeleteCursorOnReload = -1L;
            Iterator<PagePosition> iterator = this.recoveredACK.iterator();
            while (iterator.hasNext()) {
                PagePosition pos;
                this.lastAckedPosition = pos = iterator.next();
                PageCursorInfo pageInfo = this.getPageInfo(pos);
                if (pageInfo == null) {
                    ActiveMQServerLogger.LOGGER.pageNotFound(pos);
                    if (txDeleteCursorOnReload == -1L) {
                        txDeleteCursorOnReload = this.store.generateID();
                    }
                    this.store.deleteCursorAcknowledgeTransactional(txDeleteCursorOnReload, pos.getRecordID());
                    continue;
                }
                pageInfo.loadACK(pos);
            }
            if (txDeleteCursorOnReload >= 0L) {
                this.store.commit(txDeleteCursorOnReload);
            }
            this.recoveredACK.clear();
            this.recoveredACK = null;
        }
    }

    @Override
    public void flushExecutors() {
        if (!this.executor.flush(10L, TimeUnit.SECONDS)) {
            ActiveMQServerLogger.LOGGER.timedOutFlushingExecutorsPagingCursor(this);
        }
    }

    @Override
    public void stop() {
        this.flushExecutors();
    }

    @Override
    public void printDebug() {
        this.printDebug(this.toString());
    }

    public void printDebug(String msg) {
        System.out.println("Debug information on PageCurorImpl- " + msg);
        for (PageCursorInfo info : this.consumedPages.values()) {
            System.out.println(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeletePage(Page deletedPage) throws Exception {
        PageCursorInfo info;
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            info = (PageCursorInfo)this.consumedPages.remove(deletedPage.getPageId());
        }
        if (info != null) {
            PagePosition completeInfo = info.getCompleteInfo();
            if (completeInfo != null) {
                try {
                    this.store.deletePageComplete(completeInfo.getRecordID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDeletingPageCompleteRecord(e);
                }
                info.setCompleteInfo(null);
            }
            for (PagePosition deleteInfo : info.acks) {
                if (deleteInfo.getRecordID() < 0L) continue;
                try {
                    this.store.deleteCursorAcknowledge(deleteInfo.getRecordID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDeletingPageCompleteRecord(e);
                }
            }
            info.acks.clear();
        }
    }

    @Override
    public ArtemisExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void reloadPageInfo(long pageNr) {
        this.getPageInfo(pageNr);
    }

    private PageCursorInfo getPageInfo(PagePosition pos) {
        return this.getPageInfo(pos.getPageNr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageCursorInfo getPageInfo(long pageNr) {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(pageNr);
            if (pageInfo == null) {
                PageCache cache = this.cursorProvider.getPageCache(pageNr);
                if (cache == null) {
                    return null;
                }
                assert (pageNr == cache.getPageId());
                pageInfo = new PageCursorInfo(cache);
                this.consumedPages.put(pageNr, pageInfo);
            }
            return pageInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEmptyPageAsConsumedPage(PageCache cache) {
        if (cache != null && cache.getNumberOfMessages() == 0) {
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(cache.getPageId());
                if (pageInfo == null) {
                    this.consumedPages.put(cache.getPageId(), new PageCursorInfo(cache));
                }
            }
        }
    }

    private boolean match(Message message) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.match(message);
    }

    private PageCursorInfo processACK(PagePosition pos) {
        PageCursorInfo info;
        if (this.lastAckedPosition == null || pos.compareTo(this.lastAckedPosition) > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"a new position is being processed as ACK");
            }
            if (this.lastAckedPosition != null && this.lastAckedPosition.getPageNr() != pos.getPageNr()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Scheduling cleanup on pageSubscription for address = " + this.pageStore.getAddress() + " queue = " + this.getQueue().getName()));
                }
                if (this.autoCleanup) {
                    this.scheduleCleanupCheck();
                }
            }
            this.lastAckedPosition = pos;
        }
        if ((info = this.getPageInfo(pos)) == null) {
            ActiveMQServerLogger.LOGGER.nullPageCursorInfo(this.getPagingStore().getAddress().toString(), pos.toString(), this.cursorId);
        } else {
            info.addACK(pos);
        }
        return info;
    }

    private void installTXCallback(Transaction tx, PagePosition position) {
        this.installTXCallback(tx, position, -1L);
    }

    private void installTXCallback(Transaction tx, PagePosition position, long persistentSize) {
        PageCursorInfo info;
        PageCache cache;
        if (position.getRecordID() >= 0L) {
            tx.setContainsPersistent();
        }
        if ((cache = (info = this.getPageInfo(position)).getCache()) != null) {
            long size = persistentSize < 0L ? this.getPersistentSize(cache.getMessage(position)) : persistentSize;
            position.setPersistentSize(size);
        }
        logger.tracef("InstallTXCallback looking up pagePosition %s, result=%s", (Object)position, (Object)info);
        info.remove(position);
        PageCursorTX cursorTX = (PageCursorTX)tx.getProperty(8);
        if (cursorTX == null) {
            cursorTX = new PageCursorTX();
            tx.putProperty(8, cursorTX);
            tx.addOperation(cursorTX);
        }
        cursorTX.addPositionConfirmation(this, position);
    }

    private PageTransactionInfo getPageTransaction(PagedReference reference) throws ActiveMQException {
        if (reference.getTransactionID() >= 0L) {
            return this.pageStore.getPagingManager().getTransaction(reference.getTransactionID());
        }
        return null;
    }

    private void onPageDone(PageCursorInfo info) {
        if (this.autoCleanup) {
            this.scheduleCleanupCheck();
        }
    }

    @Override
    public long getDeliveredCount() {
        return this.deliveredCount.get();
    }

    @Override
    public long getDeliveredSize() {
        return this.deliveredSize.get();
    }

    @Override
    public void incrementDeliveredSize(long size) {
        this.deliveredSize.addAndGet(size);
    }

    private long getPersistentSize(PagedMessage msg) {
        try {
            return msg != null && msg.getPersistentSize() > 0L ? msg.getPersistentSize() : 0L;
        }
        catch (ActiveMQException e) {
            logger.warn((Object)("Error computing persistent size of message: " + msg), (Throwable)e);
            return 0L;
        }
    }

    private long getPersistentSize(PagedReference ref) {
        try {
            return ref != null && ref.getPersistentSize() > 0L ? ref.getPersistentSize() : 0L;
        }
        catch (ActiveMQException e) {
            logger.warn((Object)("Error computing persistent size of message: " + ref), (Throwable)e);
            return 0L;
        }
    }

    protected static class PagePositionAndFileOffset {
        private final int nextFileOffset;
        private final PagePosition pagePosition;

        PagePositionAndFileOffset(int nextFileOffset, PagePosition pagePosition) {
            this.nextFileOffset = nextFileOffset;
            this.pagePosition = pagePosition;
        }

        PagePosition nextPagePostion() {
            int messageNr = this.pagePosition.getMessageNr();
            return new PagePositionImpl(this.pagePosition.getPageNr(), messageNr + 1, messageNr + 1 == 0 ? 0 : this.nextFileOffset);
        }
    }

    private class CursorIterator
    implements PageIterator {
        private PagePositionAndFileOffset position = null;
        private PagePositionAndFileOffset lastOperation = null;
        private volatile boolean isredelivery = false;
        private PagedReference currentDelivery = null;
        private volatile PagedReference lastRedelivery = null;
        private final boolean browsing;
        private final java.util.Queue<PagePosition> redeliveries = new LinkedList<PagePosition>();
        private volatile PagedReference cachedNext;

        private CursorIterator(boolean browsing) {
            this.browsing = browsing;
        }

        private CursorIterator() {
            this.browsing = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redeliver(PagePosition reference) {
            java.util.Queue<PagePosition> queue = this.redeliveries;
            synchronized (queue) {
                this.redeliveries.add(reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repeat() {
            if (this.isredelivery) {
                java.util.Queue<PagePosition> queue = this.redeliveries;
                synchronized (queue) {
                    this.cachedNext = this.lastRedelivery;
                }
            } else {
                this.position = this.lastOperation == null ? null : this.lastOperation;
            }
        }

        public synchronized PagedReference next() {
            if (this.cachedNext != null) {
                this.currentDelivery = this.cachedNext;
                this.cachedNext = null;
                return this.currentDelivery;
            }
            if (this.position == null) {
                this.position = PageSubscriptionImpl.this.getStartPosition();
            }
            this.currentDelivery = this.moveNext();
            return this.currentDelivery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PagedReference moveNext() {
            PageSubscriptionImpl pageSubscriptionImpl = PageSubscriptionImpl.this;
            synchronized (pageSubscriptionImpl) {
                PagedReference message;
                boolean match = false;
                PagePositionAndFileOffset lastPosition = this.position;
                PagePositionAndFileOffset tmpPosition = this.position;
                long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
                do {
                    if (System.nanoTime() - timeout > 0L) {
                        return dummyPagedRef;
                    }
                    java.util.Queue<PagePosition> queue = this.redeliveries;
                    synchronized (queue) {
                        PagePosition redelivery = this.redeliveries.poll();
                        if (redelivery != null) {
                            PagedReference redeliveredMsg;
                            this.isredelivery = true;
                            this.lastRedelivery = redeliveredMsg = PageSubscriptionImpl.this.getReference(redelivery);
                            return redeliveredMsg;
                        }
                        this.lastRedelivery = null;
                        this.isredelivery = false;
                        message = PageSubscriptionImpl.this.internalGetNext(tmpPosition);
                    }
                    if (message == null) break;
                    int nextFileOffset = message.getPosition().getFileOffset() == -1 ? -1 : message.getPosition().getFileOffset() + message.getPagedMessage().getStoredSize() + 6;
                    tmpPosition = new PagePositionAndFileOffset(nextFileOffset, message.getPosition());
                    boolean valid = true;
                    boolean ignored = false;
                    valid = PageSubscriptionImpl.this.routed(message.getPagedMessage());
                    if (!valid) {
                        ignored = true;
                    }
                    PageCursorInfo info = PageSubscriptionImpl.this.getPageInfo(message.getPosition().getPageNr());
                    this.position = tmpPosition;
                    if (!this.browsing && info != null && (info.isRemoved(message.getPosition()) || info.getCompleteInfo() != null) || info != null && info.isAck(message.getPosition())) continue;
                    if (valid && message.getPagedMessage().getTransactionID() >= 0L) {
                        PageTransactionInfo tx = PageSubscriptionImpl.this.pageStore.getPagingManager().getTransaction(message.getPagedMessage().getTransactionID());
                        if (tx == null) {
                            ActiveMQServerLogger.LOGGER.pageSubscriptionCouldntLoad(message.getPagedMessage().getTransactionID(), message.getPosition(), PageSubscriptionImpl.this.pageStore.getAddress(), PageSubscriptionImpl.this.queue.getName());
                            valid = false;
                            ignored = true;
                        } else if (tx.deliverAfterCommit(this, PageSubscriptionImpl.this, message.getPosition())) {
                            valid = false;
                            ignored = false;
                        }
                    }
                    if (valid && !this.browsing && info != null && info.isRemoved(message.getPosition())) {
                        valid = false;
                    }
                    if (valid) {
                        match = PageSubscriptionImpl.this.match(message.getMessage());
                        if (this.browsing || match) continue;
                        PageSubscriptionImpl.this.processACK(message.getPosition());
                        continue;
                    }
                    if (this.browsing || !ignored) continue;
                    PageSubscriptionImpl.this.positionIgnored(message.getPosition());
                } while (!match);
                if (message != null) {
                    this.lastOperation = lastPosition;
                }
                return message;
            }
        }

        @Override
        public synchronized int tryNext() {
            if (this.cachedNext != null) {
                return 1;
            }
            if (!PageSubscriptionImpl.this.pageStore.isPaging()) {
                return 0;
            }
            PagedReference pagedReference = this.next();
            if (pagedReference == dummyPagedRef) {
                return 2;
            }
            this.cachedNext = pagedReference;
            return this.cachedNext == null ? 0 : 1;
        }

        public synchronized boolean hasNext() {
            int status;
            while ((status = this.tryNext()) == 2) {
            }
            return status != 0;
        }

        public void remove() {
            PageCursorInfo info;
            PageSubscriptionImpl.this.deliveredCount.incrementAndGet();
            PagedReference delivery = this.currentDelivery;
            if (delivery != null && (info = PageSubscriptionImpl.this.getPageInfo(delivery.getPosition())) != null) {
                info.remove(delivery.getPosition());
            }
        }

        public void close() {
            PageReader pageReader;
            if (this.position != null && (pageReader = (PageReader)PageSubscriptionImpl.this.pageReaders.remove(this.position.pagePosition.getPageNr())) != null) {
                pageReader.close();
            }
        }
    }

    private final class PageCursorTX
    extends TransactionOperationAbstract {
        private final Map<PageSubscriptionImpl, List<PagePosition>> pendingPositions = new HashMap<PageSubscriptionImpl, List<PagePosition>>();

        private PageCursorTX() {
        }

        private void addPositionConfirmation(PageSubscriptionImpl cursor, PagePosition position) {
            List<PagePosition> list = this.pendingPositions.get(cursor);
            if (list == null) {
                list = new LinkedList<PagePosition>();
                this.pendingPositions.put(cursor, list);
            }
            list.add(position);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageSubscriptionImpl, List<PagePosition>> entry : this.pendingPositions.entrySet()) {
                PageSubscriptionImpl cursor = entry.getKey();
                List<PagePosition> positions = entry.getValue();
                for (PagePosition confirmed : positions) {
                    cursor.processACK(confirmed);
                    cursor.deliveredCount.decrementAndGet();
                    cursor.deliveredSize.addAndGet(-confirmed.getPersistentSize());
                }
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }

    public final class PageCursorInfo {
        private int numberOfMessages;
        private final long pageId;
        private Set<PagePosition> acks = Collections.synchronizedSet(new LinkedHashSet());
        private WeakReference<PageCache> cache;
        private Set<PagePosition> removedReferences = new ConcurrentHashSet();
        private final boolean wasLive;
        private final AtomicInteger pendingTX = new AtomicInteger(0);
        private boolean pendingDelete;
        private PagePosition completePage;
        private final AtomicInteger confirmed = new AtomicInteger(0);

        public boolean isAck(PagePosition position) {
            return this.completePage != null || this.acks.contains(position);
        }

        public String toString() {
            try {
                return "PageCursorInfo::pageNr=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed + ", isDone=" + this.isDone() + " wasLive = " + this.wasLive;
            }
            catch (Exception e) {
                return "PageCursorInfo::pageNr=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed + ", isDone=" + e.toString();
            }
        }

        private PageCursorInfo(long pageId, int numberOfMessages) {
            if (numberOfMessages < 0) {
                throw new IllegalStateException("numberOfMessages = " + numberOfMessages + " instead of being >=0");
            }
            this.pageId = pageId;
            this.wasLive = false;
            this.numberOfMessages = numberOfMessages;
            logger.tracef("Created PageCursorInfo for pageNr=%d, numberOfMessages=%d, not live", pageId, (long)numberOfMessages);
        }

        private PageCursorInfo(PageCache cache) {
            Objects.requireNonNull(cache);
            this.pageId = cache.getPageId();
            this.wasLive = cache.isLive();
            this.cache = new WeakReference<PageCache>(cache);
            if (!this.wasLive) {
                int numberOfMessages = cache.getNumberOfMessages();
                assert (numberOfMessages >= 0);
                this.numberOfMessages = numberOfMessages;
                logger.tracef("Created PageCursorInfo for pageNr=%d, numberOfMessages=%d,  cache=%s, not live", this.pageId, (long)this.numberOfMessages, (Object)cache);
            } else {
                this.numberOfMessages = -1;
                logger.tracef("Created PageCursorInfo for pageNr=%d, cache=%s, live", this.pageId, (Object)cache);
            }
        }

        public void setCompleteInfo(PagePosition completePage) {
            logger.tracef("Setting up complete page %s on cursor %s on subscription %s", (Object)completePage, (Object)this, (Object)PageSubscriptionImpl.this);
            this.completePage = completePage;
        }

        public PagePosition getCompleteInfo() {
            return this.completePage;
        }

        public boolean isDone() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(PageSubscriptionImpl.this + "::PageCursorInfo(" + this.pageId + ")::isDone checking with completePage!=null->" + (this.completePage != null) + " getNumberOfMessages=" + this.getNumberOfMessages() + ", confirmed=" + this.confirmed.get() + " and pendingTX=" + this.pendingTX.get()));
            }
            return this.completePage != null || this.getNumberOfMessages() == this.confirmed.get() && this.pendingTX.get() == 0;
        }

        public boolean isPendingDelete() {
            return this.pendingDelete || this.completePage != null;
        }

        public void setPendingDelete() {
            this.pendingDelete = true;
        }

        public long getPageId() {
            return this.pageId;
        }

        public void incrementPendingTX() {
            this.pendingTX.incrementAndGet();
        }

        public void decrementPendingTX() {
            this.pendingTX.decrementAndGet();
            this.checkDone();
        }

        public boolean isRemoved(PagePosition pos) {
            return this.removedReferences.contains(pos);
        }

        public void remove(PagePosition position) {
            this.removedReferences.add(position);
        }

        public void addACK(PagePosition posACK) {
            boolean added;
            if (logger.isTraceEnabled()) {
                try {
                    logger.trace((Object)("numberOfMessages =  " + this.getNumberOfMessages() + " confirmed =  " + (this.confirmed.get() + 1) + " pendingTX = " + this.pendingTX + ", pageNr = " + this.pageId + " posACK = " + posACK));
                }
                catch (Throwable ignored) {
                    logger.debug((Object)ignored.getMessage(), ignored);
                }
            }
            if ((added = this.internalAddACK(posACK)) && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
                this.checkDone();
            }
        }

        public void loadACK(PagePosition posACK) {
            if (this.internalAddACK(posACK) && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
            }
        }

        private boolean internalAddACK(PagePosition posACK) {
            this.removedReferences.add(posACK);
            return this.acks.add(posACK);
        }

        protected void checkDone() {
            if (this.isDone()) {
                PageSubscriptionImpl.this.onPageDone(this);
            }
        }

        private int getNumberOfMessagesFromPageCache() {
            PageCache localCache = (PageCache)this.cache.get();
            if (localCache == null) {
                localCache = PageSubscriptionImpl.this.cursorProvider.getPageCache(this.pageId);
                this.cache = new WeakReference<PageCache>(localCache);
            }
            int numberOfMessage = localCache.getNumberOfMessages();
            if (!localCache.isLive()) {
                this.numberOfMessages = numberOfMessage;
            }
            return numberOfMessage;
        }

        private int getNumberOfMessages() {
            int numberOfMessages = this.numberOfMessages;
            if (this.wasLive) {
                if (numberOfMessages < 0) {
                    return this.getNumberOfMessagesFromPageCache();
                }
                return numberOfMessages;
            }
            assert (numberOfMessages >= 0);
            return numberOfMessages;
        }

        public PageCache getCache() {
            return this.cache != null ? (PageCache)this.cache.get() : null;
        }

        public int getPendingTx() {
            return this.pendingTX.get();
        }
    }
}

