/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.junit3;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.ant.antunit.junit3.AntUnitSuite;
import org.apache.tools.ant.BuildException;

public class AntUnitTestCase
extends TestCase {
    private final AntUnitSuite suite;
    private final String target;
    private final BuildException initialisationException;

    public AntUnitTestCase(String name) {
        super(name);
        BuildException catchedEx = null;
        AntUnitSuite createdSuite = null;
        TestCaseName nameParser = new TestCaseName(name);
        try {
            createdSuite = new AntUnitSuite(this, nameParser.getScript());
        }
        catch (BuildException e) {
            catchedEx = e;
        }
        this.initialisationException = catchedEx;
        this.suite = createdSuite;
        this.target = nameParser.getTarget();
    }

    public AntUnitTestCase(AntUnitSuite suite, File scriptFile, String target) {
        super(new TestCaseName(scriptFile, target).getName());
        this.target = target;
        this.suite = suite;
        this.initialisationException = null;
    }

    public String getTarget() {
        return this.target;
    }

    public void run(TestResult result) {
        if (this.initialisationException == null && this.suite != null) {
            this.suite.runTest((Test)this, result);
        } else {
            super.run(result);
        }
    }

    protected void runTest() throws BuildException {
        throw this.initialisationException;
    }

    static class TestCaseName {
        private final String name;
        private final File script;
        private final String target;

        public TestCaseName(String name) {
            this.name = name;
            this.target = name.substring(0, name.indexOf(32));
            String filename = name.substring(name.indexOf(32) + 2, name.length() - 1);
            this.script = new File(filename);
        }

        public TestCaseName(File script, String target) {
            this.script = script;
            this.target = target;
            this.name = target + " [" + script + "]";
        }

        public String getName() {
            return this.name;
        }

        public File getScript() {
            return this.script;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

