/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ext.impl.ExtNamespaceHandler;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.xml.sax.SAXException;

public class SimpleNamespaceHandlerSet
implements NamespaceHandlerSet {
    public static final URI EXT_1_2_NAMESPACE = URI.create("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.2.0");
    private Map<URI, URL> namespaces = new LinkedHashMap<URI, URL>();
    private Map<URI, NamespaceHandler> handlers = new LinkedHashMap<URI, NamespaceHandler>();
    private Schema schema;

    public SimpleNamespaceHandlerSet() {
        this.addNamespace(EXT_1_2_NAMESPACE, this.getClass().getResource("/org/apache/aries/blueprint/ext/impl/blueprint-ext-1.2.xsd"), new ExtNamespaceHandler());
    }

    @Override
    public Set<URI> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces.keySet());
    }

    public void addNamespace(URI namespace, URL schema, NamespaceHandler handler) {
        this.namespaces.put(namespace, schema);
        this.handlers.put(namespace, handler);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public NamespaceHandler getNamespaceHandler(URI uri) {
        return this.handlers.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchema() throws SAXException, IOException {
        if (this.schema == null) {
            ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            try {
                InputStream is = this.getClass().getResourceAsStream("/org/apache/aries/blueprint/blueprint.xsd");
                streams.add(is);
                schemaSources.add(new StreamSource(is));
                for (URI uri : this.namespaces.keySet()) {
                    is = this.namespaces.get(uri).openStream();
                    streams.add(is);
                    schemaSources.add(new StreamSource(is));
                }
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                this.schema = schemaFactory.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
            }
            finally {
                for (InputStream is : streams) {
                    is.close();
                }
            }
        }
        return this.schema;
    }

    @Override
    public void addListener(NamespaceHandlerSet.Listener listener) {
        throw new IllegalStateException();
    }

    @Override
    public void removeListener(NamespaceHandlerSet.Listener listener) {
        throw new IllegalStateException();
    }

    @Override
    public void destroy() {
        this.schema = null;
    }
}

