/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.PropertyData;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.jmx.framework.wiring.BundleWiringStateMBean;

public class BundleWiringData {
    private final long bundleId;
    private final int revisionId;
    private final List<BundleCapability> capabilities;
    private final List<BundleRequirement> requirements;
    private final List<BundleWire> providedWires;
    private final List<BundleWire> requiredWires;
    private final Map<BundleRevision, Integer> revisionIDMap;

    public BundleWiringData(long bundleId, int revisionId, List<BundleCapability> capabilities, List<BundleRequirement> requirements, List<BundleWire> providedWires, List<BundleWire> requiredWires, Map<BundleRevision, Integer> revisionIDMap) {
        this.bundleId = bundleId;
        this.revisionId = revisionId;
        this.capabilities = capabilities;
        this.requirements = requirements;
        this.providedWires = providedWires;
        this.requiredWires = requiredWires;
        this.revisionIDMap = revisionIDMap;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("BundleId", this.bundleId);
            items.put("BundleRevisionId", this.revisionId);
            items.put("Requirements", BundleWiringData.getRequirements(this.requirements));
            items.put("Capabilities", BundleWiringData.getCapabilities(this.capabilities));
            items.put("RequiredWires", this.getRequiredWires());
            items.put("ProvidedWires", this.getProvidedWires());
            return new CompositeDataSupport(BundleWiringStateMBean.BUNDLE_WIRING_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData", e);
        }
    }

    private static CompositeData[] getCapabilities(List<BundleCapability> capabilityList) throws OpenDataException {
        CompositeData[] capData = new CompositeData[capabilityList.size()];
        for (int i = 0; i < capabilityList.size(); ++i) {
            BundleCapability capability = capabilityList.get(i);
            capData[i] = BundleWiringData.getCapReqCompositeData(BundleWiringStateMBean.BUNDLE_CAPABILITY_TYPE, capability.getNamespace(), capability.getAttributes().entrySet(), capability.getDirectives().entrySet());
        }
        return capData;
    }

    private static CompositeData[] getRequirements(List<BundleRequirement> requirementList) throws OpenDataException {
        CompositeData[] reqData = new CompositeData[requirementList.size()];
        for (int i = 0; i < requirementList.size(); ++i) {
            BundleRequirement requirement = requirementList.get(i);
            reqData[i] = BundleWiringData.getCapReqCompositeData(BundleWiringStateMBean.BUNDLE_REQUIREMENT_TYPE, requirement.getNamespace(), requirement.getAttributes().entrySet(), requirement.getDirectives().entrySet());
        }
        return reqData;
    }

    public static CompositeData getRevisionCapabilities(int revisionId, List<BundleCapability> bundleCapabilities) {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("BundleRevisionId", revisionId);
            items.put("Capabilities", BundleWiringData.getCapabilities(bundleCapabilities));
            return new CompositeDataSupport(BundleWiringStateMBean.REVISION_CAPABILITIES_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData", e);
        }
    }

    public static CompositeData getRevisionRequirements(int revisionId, List<BundleRequirement> bundleRequirements) {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("BundleRevisionId", revisionId);
            items.put("Requirements", BundleWiringData.getRequirements(bundleRequirements));
            return new CompositeDataSupport(BundleWiringStateMBean.REVISION_REQUIREMENTS_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData", e);
        }
    }

    public static CompositeData[] getCapabilitiesCompositeData(List<BundleCapability> bundleCapabilities) {
        try {
            CompositeData[] data = new CompositeData[bundleCapabilities.size()];
            for (int i = 0; i < bundleCapabilities.size(); ++i) {
                CompositeData cd;
                BundleCapability requirement = bundleCapabilities.get(i);
                data[i] = cd = BundleWiringData.getCapReqCompositeData(BundleWiringStateMBean.BUNDLE_CAPABILITY_TYPE, requirement.getNamespace(), requirement.getAttributes().entrySet(), requirement.getDirectives().entrySet());
            }
            return data;
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData", e);
        }
    }

    public static CompositeData[] getRequirementsCompositeData(List<BundleRequirement> bundleRequirements) {
        try {
            CompositeData[] data = new CompositeData[bundleRequirements.size()];
            for (int i = 0; i < bundleRequirements.size(); ++i) {
                CompositeData cd;
                BundleRequirement requirement = bundleRequirements.get(i);
                data[i] = cd = BundleWiringData.getCapReqCompositeData(BundleWiringStateMBean.BUNDLE_REQUIREMENT_TYPE, requirement.getNamespace(), requirement.getAttributes().entrySet(), requirement.getDirectives().entrySet());
            }
            return data;
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData", e);
        }
    }

    private static CompositeData getCapReqCompositeData(CompositeType type, String namespace, Set<Map.Entry<String, Object>> attributeSet, Set<Map.Entry<String, String>> directiveSet) throws OpenDataException {
        HashMap<String, Object> reqItems = new HashMap<String, Object>();
        TabularDataSupport attributes = new TabularDataSupport(BundleWiringStateMBean.ATTRIBUTES_TYPE);
        for (Map.Entry<String, Object> entry : attributeSet) {
            PropertyData<Object> pd = PropertyData.newInstance(entry.getKey(), entry.getValue());
            attributes.put(pd.toCompositeData());
        }
        reqItems.put("Attributes", attributes);
        TabularDataSupport directives = new TabularDataSupport(BundleWiringStateMBean.DIRECTIVES_TYPE);
        for (Map.Entry<String, String> entry : directiveSet) {
            CompositeDataSupport directive = new CompositeDataSupport(BundleWiringStateMBean.DIRECTIVE_TYPE, new String[]{"Key", "Value"}, new Object[]{entry.getKey(), entry.getValue()});
            directives.put(directive);
        }
        reqItems.put("Directives", directives);
        reqItems.put("Namespace", namespace);
        CompositeDataSupport req = new CompositeDataSupport(type, reqItems);
        return req;
    }

    private CompositeData[] getProvidedWires() throws OpenDataException {
        return this.getWiresCompositeData(this.providedWires);
    }

    private CompositeData[] getRequiredWires() throws OpenDataException {
        return this.getWiresCompositeData(this.requiredWires);
    }

    private CompositeData[] getWiresCompositeData(List<BundleWire> wires) throws OpenDataException {
        CompositeData[] reqWiresData = new CompositeData[wires.size()];
        for (int i = 0; i < wires.size(); ++i) {
            BundleWire requiredWire = wires.get(i);
            HashMap<String, Object> wireItems = new HashMap<String, Object>();
            BundleCapability capability = requiredWire.getCapability();
            wireItems.put("ProviderBundleId", capability.getRevision().getBundle().getBundleId());
            wireItems.put("ProviderBundleRevisionId", this.revisionIDMap.get(capability.getRevision()));
            wireItems.put("BundleCapability", BundleWiringData.getCapReqCompositeData(BundleWiringStateMBean.BUNDLE_CAPABILITY_TYPE, capability.getNamespace(), capability.getAttributes().entrySet(), capability.getDirectives().entrySet()));
            BundleRequirement requirement = requiredWire.getRequirement();
            wireItems.put("RequirerBundleId", requirement.getRevision().getBundle().getBundleId());
            wireItems.put("RequirerBundleRevisionId", this.revisionIDMap.get(requirement.getRevision()));
            wireItems.put("BundleRequirement", BundleWiringData.getCapReqCompositeData(BundleWiringStateMBean.BUNDLE_REQUIREMENT_TYPE, requirement.getNamespace(), requirement.getAttributes().entrySet(), requirement.getDirectives().entrySet()));
            CompositeDataSupport wireData = new CompositeDataSupport(BundleWiringStateMBean.BUNDLE_WIRE_TYPE, wireItems);
            reqWiresData[i] = wireData;
        }
        return reqWiresData;
    }
}

