/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Clause;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;

public class GenericClause
implements Clause {
    private static final String REGEX = "((?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\"(?:;(?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\")*)(?:;\\s*((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))))*";
    private static final Pattern PATTERN = Pattern.compile("((?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\"(?:;(?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\")*)(?:;\\s*((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))))*");
    private static final Pattern PATTERN_PARAMETER = Pattern.compile("(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))");
    private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private final String path;

    public GenericClause(String clause) {
        Matcher matcher = PATTERN.matcher(clause);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid clause: " + clause);
        }
        this.path = matcher.group(1);
        matcher = PATTERN_PARAMETER.matcher(clause);
        while (matcher.find()) {
            String group = matcher.group();
            if (group == null || group.length() == 0) continue;
            Parameter parameter = ParameterFactory.create(group);
            this.parameters.put(parameter.getName(), parameter);
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        Parameter result = this.parameters.get(name);
        if (result instanceof Attribute) {
            return (Attribute)result;
        }
        return null;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
        for (Parameter parameter : this.parameters.values()) {
            if (!(parameter instanceof Attribute)) continue;
            attributes.add((Attribute)parameter);
        }
        attributes.trimToSize();
        return attributes;
    }

    @Override
    public Directive getDirective(String name) {
        Parameter result = this.parameters.get(name);
        if (result instanceof Directive) {
            return (Directive)result;
        }
        return null;
    }

    @Override
    public Collection<Directive> getDirectives() {
        ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
        for (Parameter parameter : this.parameters.values()) {
            if (!(parameter instanceof Directive)) continue;
            directives.add((Directive)parameter);
        }
        directives.trimToSize();
        return directives;
    }

    @Override
    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Collection<Parameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters.values());
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

