/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.internal.AbstractAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.StartResourceComparator;
import org.apache.aries.subsystem.core.internal.SubsystemIdentifier;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(StopAction.class);

    public StopAction(BasicSubsystem requestor, BasicSubsystem target, boolean disableRootCheck) {
        super(requestor, target, disableRootCheck);
    }

    @Override
    public Object run() {
        this.checkRoot();
        Subsystem.State state = this.target.getState();
        if (EnumSet.of(Subsystem.State.INSTALLED, Subsystem.State.RESOLVED).contains(state)) {
            return null;
        }
        if (EnumSet.of(Subsystem.State.INSTALL_FAILED, Subsystem.State.UNINSTALLING, Subsystem.State.UNINSTALLED).contains(state)) {
            throw new IllegalStateException("Cannot stop from state " + state);
        }
        if (EnumSet.of(Subsystem.State.INSTALLING, Subsystem.State.RESOLVING, Subsystem.State.STARTING, Subsystem.State.STOPPING).contains(state)) {
            this.waitForStateChange();
            return new StopAction(this.requestor, this.target, this.disableRootCheck).run();
        }
        this.target.setState(Subsystem.State.STOPPING);
        ArrayList<Resource> resources = new ArrayList<Resource>(Activator.getInstance().getSubsystems().getResourcesReferencedBy(this.target));
        SubsystemContentHeader header = this.target.getSubsystemManifest().getSubsystemContentHeader();
        if (header != null) {
            Collections.sort(resources, new StartResourceComparator(this.target.getSubsystemManifest().getSubsystemContentHeader()));
            Collections.reverse(resources);
        }
        for (Resource resource : resources) {
            if (Utils.isRegionContextBundle(resource)) continue;
            try {
                this.stopResource(resource);
            }
            catch (Exception e) {
                logger.error("An error occurred while stopping resource " + resource + " of subsystem " + this.target, (Throwable)e);
            }
        }
        this.target.setState(Subsystem.State.RESOLVED);
        try {
            this.target.setDeploymentManifest(new DeploymentManifest(this.target.getDeploymentManifest(), null, this.target.isAutostart(), this.target.getSubsystemId(), SubsystemIdentifier.getLastId(), this.target.getLocation(), false, false));
        }
        catch (Exception e) {
            throw new SubsystemException((Throwable)e);
        }
        return null;
    }

    private void stopBundleResource(Resource resource) throws BundleException {
        if (this.target.isRoot()) {
            return;
        }
        ((BundleRevision)resource).getBundle().stop();
    }

    private void stopResource(Resource resource) throws BundleException, IOException {
        if (Utils.getActiveUseCount(resource) > 0) {
            return;
        }
        String type = ResourceHelper.getTypeAttribute(resource);
        if ("osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type)) {
            this.stopSubsystemResource(resource);
        } else if ("osgi.bundle".equals(type)) {
            this.stopBundleResource(resource);
        } else {
            if ("osgi.fragment".equals(type)) {
                return;
            }
            throw new SubsystemException("Unsupported resource type: " + type);
        }
    }

    private void stopSubsystemResource(Resource resource) throws IOException {
        new StopAction(this.target, (BasicSubsystem)resource, !((BasicSubsystem)resource).isRoot()).run();
    }
}

