/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;

@InterfaceAudience.Private
public class HamletImpl
extends HamletSpec {
    private static final String INDENT_CHARS = "  ";
    private static final Splitter SS = Splitter.on((char)'.').omitEmptyStrings().trimResults();
    private static final Joiner SJ = Joiner.on((char)' ');
    private static final Joiner CJ = Joiner.on((String)", ");
    static final int S_ID = 0;
    static final int S_CLASS = 1;
    int nestLevel;
    int indents;
    private final PrintWriter out;
    private final StringBuilder sb = new StringBuilder();
    private boolean wasInline = false;

    public HamletImpl(PrintWriter out, int nestLevel, boolean wasInline) {
        this.out = out;
        this.nestLevel = nestLevel;
        this.wasInline = wasInline;
    }

    public int nestLevel() {
        return this.nestLevel;
    }

    public boolean wasInline() {
        return this.wasInline;
    }

    public void setWasInline(boolean state) {
        this.wasInline = state;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public <T extends HamletSpec._> Generic<T> root(String name, EnumSet<EOpt> opts) {
        return new Generic(this, name, null, opts);
    }

    public <T extends HamletSpec._> Generic<T> root(String name) {
        return this.root(name, EnumSet.of(EOpt.ENDTAG));
    }

    protected void printStartTag(String name, EnumSet<EOpt> opts) {
        this.indent(opts);
        this.sb.setLength(0);
        this.out.print(this.sb.append('<').append(name).toString());
    }

    protected void indent(EnumSet<EOpt> opts) {
        if (opts.contains((Object)EOpt.INLINE) && this.wasInline) {
            return;
        }
        if (this.wasInline) {
            this.out.println();
        }
        this.wasInline = opts.contains((Object)EOpt.INLINE) || opts.contains((Object)EOpt.PRE);
        for (int i = 0; i < this.nestLevel; ++i) {
            this.out.print(INDENT_CHARS);
        }
        ++this.indents;
    }

    protected void printEndTag(String name, EnumSet<EOpt> opts) {
        if (!opts.contains((Object)EOpt.ENDTAG)) {
            return;
        }
        if (!opts.contains((Object)EOpt.PRE)) {
            this.indent(opts);
        } else {
            this.wasInline = opts.contains((Object)EOpt.INLINE);
        }
        this.sb.setLength(0);
        this.out.print(this.sb.append("</").append(name).append('>').toString());
        if (!opts.contains((Object)EOpt.INLINE)) {
            this.out.println();
        }
    }

    protected void printAttr(String name, String value) {
        this.sb.setLength(0);
        this.sb.append(' ').append(name);
        if (value != null) {
            this.sb.append("=\"").append(StringEscapeUtils.escapeHtml((String)value)).append("\"");
        }
        this.out.print(this.sb.toString());
    }

    protected void subView(Class<? extends SubView> cls) {
        this.indent(EnumSet.of(EOpt.ENDTAG));
        this.sb.setLength(0);
        this.out.print(this.sb.append('[').append(cls.getName()).append(']').toString());
        this.out.println();
    }

    public static String[] parseSelector(String selector) {
        String[] result = new String[]{null, null};
        Iterable rs = SS.split((CharSequence)selector);
        Iterator it = rs.iterator();
        if (it.hasNext()) {
            String maybeId = (String)it.next();
            if (maybeId.charAt(0) == '#') {
                result[0] = maybeId.substring(1);
                if (it.hasNext()) {
                    result[1] = SJ.join(Iterables.skip((Iterable)rs, (int)1));
                }
            } else {
                result[1] = SJ.join(rs);
            }
            return result;
        }
        throw new WebAppException("Error parsing selector: " + selector);
    }

    public static <E extends HamletSpec.CoreAttrs> E setSelector(E e, String selector) {
        String[] res = HamletImpl.parseSelector(selector);
        if (res[0] != null) {
            e.$id(res[0]);
        }
        if (res[1] != null) {
            e.$class(res[1]);
        }
        return e;
    }

    public static <E extends HamletSpec.LINK> E setLinkHref(E e, String href) {
        if (href.endsWith(".css")) {
            e.$rel("stylesheet");
        }
        e.$href(href);
        return e;
    }

    public static <E extends HamletSpec.SCRIPT> E setScriptSrc(E e, String src) {
        if (src.endsWith(".js")) {
            e.$type("text/javascript");
        }
        e.$src(src);
        return e;
    }

    public static class Generic<T extends HamletSpec._>
    extends EImp<T>
    implements HamletSpec.PCData {
        final /* synthetic */ HamletImpl this$0;

        Generic(String name, T parent, EnumSet<EOpt> opts) {
            this.this$0 = var1_1;
            super((HamletImpl)var1_1, name, parent, opts);
        }

        public Generic<T> _inline() {
            super._inline(true);
            return this;
        }

        public Generic<T> _noEndTag() {
            super._endTag(false);
            return this;
        }

        public Generic<T> _pre() {
            super._pre(true);
            return this;
        }

        public Generic<T> _attr(String name, String value) {
            this.addAttr(name, value);
            return this;
        }

        public Generic<Generic<T>> _elem(String name, EnumSet<EOpt> opts) {
            this.closeAttrs();
            return new Generic(this.this$0, name, (HamletSpec._)this, opts);
        }

        public Generic<Generic<T>> elem(String name) {
            return this._elem(name, EnumSet.of(EOpt.ENDTAG));
        }

        @Override
        public Generic<T> _(Object ... lines) {
            this._p(true, lines);
            return this;
        }

        @Override
        public Generic<T> _r(Object ... lines) {
            this._p(false, lines);
            return this;
        }
    }

    public static class EImp<T extends HamletSpec._>
    implements HamletSpec._Child {
        private final String name;
        private final T parent;
        private final EnumSet<EOpt> opts;
        private boolean started = false;
        private boolean attrsClosed = false;
        final /* synthetic */ HamletImpl this$0;

        EImp(String name, T parent, EnumSet<EOpt> opts) {
            this.this$0 = var1_1;
            this.name = name;
            this.parent = parent;
            this.opts = opts;
        }

        public T _() {
            this.closeAttrs();
            --this.this$0.nestLevel;
            this.this$0.printEndTag(this.name, this.opts);
            return this.parent;
        }

        protected void _p(boolean quote, Object ... args) {
            this.closeAttrs();
            for (Object s : args) {
                if (!this.opts.contains((Object)EOpt.PRE)) {
                    this.this$0.indent(this.opts);
                }
                this.this$0.out.print(quote ? StringEscapeUtils.escapeHtml((String)String.valueOf(s)) : String.valueOf(s));
                if (this.opts.contains((Object)EOpt.INLINE) || this.opts.contains((Object)EOpt.PRE)) continue;
                this.this$0.out.println();
            }
        }

        protected void _v(Class<? extends SubView> cls) {
            this.closeAttrs();
            this.this$0.subView(cls);
        }

        protected void closeAttrs() {
            if (!this.attrsClosed) {
                this.startIfNeeded();
                ++this.this$0.nestLevel;
                this.this$0.out.print('>');
                if (!this.opts.contains((Object)EOpt.INLINE) && !this.opts.contains((Object)EOpt.PRE)) {
                    this.this$0.out.println();
                }
                this.attrsClosed = true;
            }
        }

        protected void addAttr(String name, String value) {
            Preconditions.checkState((!this.attrsClosed ? 1 : 0) != 0, (Object)"attribute added after content");
            this.startIfNeeded();
            this.this$0.printAttr(name, value);
        }

        protected void addAttr(String name, Object value) {
            this.addAttr(name, String.valueOf(value));
        }

        protected void addMediaAttr(String name, EnumSet<HamletSpec.Media> media) {
            this.addAttr(name, CJ.join(media));
        }

        protected void addRelAttr(String name, EnumSet<HamletSpec.LinkType> types) {
            this.addAttr(name, SJ.join(types));
        }

        private void startIfNeeded() {
            if (!this.started) {
                this.this$0.printStartTag(this.name, this.opts);
                this.started = true;
            }
        }

        protected void _inline(boolean choice) {
            if (choice) {
                this.opts.add(EOpt.INLINE);
            } else {
                this.opts.remove((Object)EOpt.INLINE);
            }
        }

        protected void _endTag(boolean choice) {
            if (choice) {
                this.opts.add(EOpt.ENDTAG);
            } else {
                this.opts.remove((Object)EOpt.ENDTAG);
            }
        }

        protected void _pre(boolean choice) {
            if (choice) {
                this.opts.add(EOpt.PRE);
            } else {
                this.opts.remove((Object)EOpt.PRE);
            }
        }
    }

    public static enum EOpt {
        ENDTAG,
        INLINE,
        PRE;

    }
}

