/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import java.io.DataOutput;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.external.library.java.base.JObject;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class JDuration
extends JObject<Duration> {
    public JDuration(int months, long milliseconds) {
        super((IAObject)new AMutableDuration(months, milliseconds));
    }

    public void setValue(int months, long milliseconds) {
        ((AMutableDuration)this.value).setValue(months, milliseconds);
    }

    @Override
    public Duration getValueGeneric() {
        int months = ((AMutableDuration)this.value).getMonths();
        long millis = ((AMutableDuration)this.value).getMilliseconds();
        return Duration.of(months, ChronoUnit.MONTHS).plusMillis(millis);
    }

    @Override
    public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        this.serializeTypeTag(writeTypeTag, dataOutput, ATypeTag.DURATION);
        ADurationSerializerDeserializer.INSTANCE.serialize((ADuration)((AMutableDuration)this.value), dataOutput);
    }

    @Override
    public void reset() {
        ((AMutableDuration)this.value).setValue(0, 0L);
    }

    @Override
    public IAType getIAType() {
        return BuiltinType.ADURATION;
    }

    @Override
    public void setValueGeneric(Duration o) {
        long months = o.get(ChronoUnit.MONTHS);
        if (months > Integer.MAX_VALUE) {
            throw new ArithmeticException("Overflow");
        }
        long ms = o.minus(Duration.of(months, ChronoUnit.MONTHS)).get(ChronoUnit.MILLIS);
        this.setValue((int)months, ms);
    }
}

