/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.InMemUtils;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class APoint3D
implements IAObject {
    protected double x;
    protected double y;
    protected double z;

    public APoint3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Override
    public IAType getType() {
        return BuiltinType.APOINT3D;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof APoint3D)) {
            return false;
        }
        APoint3D p = (APoint3D)obj;
        return this.x == p.x && this.y == p.y && this.z == p.z;
    }

    @Override
    public int hash() {
        return InMemUtils.hashDouble(this.x) + 31 * InMemUtils.hashDouble(this.y) + 961 * InMemUtils.hashDouble(this.z);
    }

    public String toString() {
        return "point3d: { x: " + this.x + ", y: " + this.y + ", z: " + this.z + " }";
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode point = om.createObjectNode();
        point.put("x", this.x);
        point.put("y", this.y);
        point.put("z", this.z);
        json.set("APoint3D", (JsonNode)point);
        return json;
    }
}

