/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.tuples;

import java.nio.ByteBuffer;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.SimpleTupleReference;
import org.apache.hyracks.storage.am.common.util.BitOperationUtils;

public class SimpleTupleWriter
implements ITreeIndexTupleWriter {
    public static final SimpleTupleWriter INSTANCE = new SimpleTupleWriter();

    private SimpleTupleWriter() {
    }

    @Override
    public int bytesRequired(ITupleReference tuple) {
        int bytes = this.getNullFlagsBytes(tuple) + this.getFieldSlotsBytes(tuple);
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    @Override
    public int bytesRequired(ITupleReference tuple, int startField, int numFields) {
        int bytes = this.getNullFlagsBytes(tuple, startField, numFields) + this.getFieldSlotsBytes(tuple, startField, numFields);
        for (int i = startField; i < startField + numFields; ++i) {
            bytes += tuple.getFieldLength(i);
        }
        return bytes;
    }

    @Override
    public SimpleTupleReference createTupleReference() {
        return new SimpleTupleReference();
    }

    @Override
    public int writeTuple(ITupleReference tuple, ByteBuffer targetBuf, int targetOff) {
        return this.writeTuple(tuple, targetBuf.array(), targetOff);
    }

    @Override
    public int writeTuple(ITupleReference tuple, byte[] targetBuf, int targetOff) {
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(tuple);
        int fieldSlotsBytes = this.getFieldSlotsBytes(tuple);
        for (int i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        runner += fieldSlotsBytes;
        int fieldEndOff = 0;
        for (int i = 0; i < tuple.getFieldCount(); ++i) {
            System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), targetBuf, runner, tuple.getFieldLength(i));
            runner += tuple.getFieldLength(i);
            IntegerPointable.setInteger((byte[])targetBuf, (int)(targetOff + nullFlagsBytes + i * 4), (int)(fieldEndOff += tuple.getFieldLength(i)));
        }
        return runner - targetOff;
    }

    @Override
    public int writeTupleFields(ITupleReference tuple, int startField, int numFields, byte[] targetBuf, int targetOff) {
        int runner = targetOff;
        int nullFlagsBytes = this.getNullFlagsBytes(tuple, startField, numFields);
        for (int i = 0; i < nullFlagsBytes; ++i) {
            targetBuf[runner++] = 0;
        }
        runner += this.getFieldSlotsBytes(tuple, startField, numFields);
        int fieldEndOff = 0;
        int fieldCounter = 0;
        for (int i = startField; i < startField + numFields; ++i) {
            System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), targetBuf, runner, tuple.getFieldLength(i));
            runner += tuple.getFieldLength(i);
            IntegerPointable.setInteger((byte[])targetBuf, (int)(targetOff + nullFlagsBytes + fieldCounter * 4), (int)(fieldEndOff += tuple.getFieldLength(i)));
            ++fieldCounter;
        }
        return runner - targetOff;
    }

    protected int getNullFlagsBytes(ITupleReference tuple) {
        return BitOperationUtils.getFlagBytes(tuple.getFieldCount());
    }

    protected int getFieldSlotsBytes(ITupleReference tuple) {
        return tuple.getFieldCount() * 4;
    }

    protected int getNullFlagsBytes(ITupleReference tuple, int startField, int numFields) {
        return BitOperationUtils.getFlagBytes(numFields);
    }

    protected int getFieldSlotsBytes(ITupleReference tuple, int startField, int numFields) {
        return numFields * 4;
    }

    @Override
    public int getCopySpaceRequired(ITupleReference tuple) {
        return this.bytesRequired(tuple);
    }
}

