/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc;

import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.api.application.ICCApplication;
import org.apache.hyracks.api.application.IServerContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.context.ICCContext;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.DeployedJobSpecIdFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobIdFactory;
import org.apache.hyracks.api.job.JobParameterByteStore;
import org.apache.hyracks.api.job.resource.IJobCapacityController;
import org.apache.hyracks.api.network.INetworkSecurityConfig;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.api.topology.ClusterTopology;
import org.apache.hyracks.api.topology.TopologyDefinitionParser;
import org.apache.hyracks.control.cc.BaseCCApplication;
import org.apache.hyracks.control.cc.ClientInterfaceIPCI;
import org.apache.hyracks.control.cc.ClusterControllerIPCI;
import org.apache.hyracks.control.cc.DeployedJobSpecStore;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.cluster.NodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobManager;
import org.apache.hyracks.control.cc.result.IResultDirectoryService;
import org.apache.hyracks.control.cc.result.ResultDirectoryService;
import org.apache.hyracks.control.cc.scheduler.IResourceManager;
import org.apache.hyracks.control.cc.scheduler.ResourceManager;
import org.apache.hyracks.control.cc.web.WebServer;
import org.apache.hyracks.control.cc.work.GatherStateDumpsWork;
import org.apache.hyracks.control.cc.work.GetIpAddressNodeNameMapWork;
import org.apache.hyracks.control.cc.work.GetThreadDumpWork;
import org.apache.hyracks.control.cc.work.RemoveDeadNodesWork;
import org.apache.hyracks.control.cc.work.ShutdownNCServiceWork;
import org.apache.hyracks.control.cc.work.TriggerNCWork;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.context.ServerContext;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.common.deployment.DeploymentRun;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.logs.LogFile;
import org.apache.hyracks.control.common.shutdown.ShutdownRun;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.common.work.WorkQueue;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.impl.JavaSerializationBasedPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.security.NetworkSecurityConfig;
import org.apache.hyracks.ipc.security.NetworkSecurityManager;
import org.apache.hyracks.util.ExitUtil;
import org.apache.hyracks.util.MaintainedThreadNameExecutorService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class ClusterControllerService
implements IControllerService {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CCConfig ccConfig;
    private final ConfigManager configManager;
    private IPCSystem clusterIPC;
    private IPCSystem clientIPC;
    private final LogFile jobLog;
    private ServerContext serverCtx;
    private WebServer webServer;
    private ClusterControllerInfo info;
    private CCServiceContext serviceCtx;
    private final DeployedJobSpecStore deployedJobSpecStore = new DeployedJobSpecStore();
    private final Map<JobId, JobParameterByteStore> jobParameterByteStoreMap = new HashMap<JobId, JobParameterByteStore>();
    private final WorkQueue workQueue;
    private ExecutorService executor;
    private final Timer timer;
    private final ICCContext ccContext;
    private final DeadNodeSweeper sweeper;
    private final IResultDirectoryService resultDirectoryService;
    private final Map<DeploymentId, DeploymentRun> deploymentRunMap;
    private final Map<String, GatherStateDumpsWork.StateDumpRun> stateDumpRunMap;
    private final Map<String, GetThreadDumpWork.ThreadDumpRun> threadDumpRunMap;
    private final INodeManager nodeManager;
    private final IResourceManager resourceManager = new ResourceManager();
    private final ICCApplication application;
    private final JobIdFactory jobIdFactory;
    private final DeployedJobSpecIdFactory deployedJobSpecIdFactory;
    private IJobManager jobManager;
    private ShutdownRun shutdownCallback;
    private final CcId ccId;
    private final INetworkSecurityManager networkSecurityManager;

    public ClusterControllerService(CCConfig config) throws Exception {
        this(config, ClusterControllerService.getApplication(config));
    }

    public ClusterControllerService(CCConfig config, ICCApplication application) throws Exception {
        this.ccConfig = config;
        this.configManager = this.ccConfig.getConfigManager();
        if (application == null) {
            throw new IllegalArgumentException("ICCApplication cannot be null");
        }
        this.application = application;
        File jobLogFolder = new File(this.ccConfig.getRootDir(), "logs/jobs");
        this.jobLog = new LogFile(jobLogFolder);
        INetworkSecurityConfig securityConfig = this.getNetworkSecurityConfig();
        this.networkSecurityManager = new NetworkSecurityManager(securityConfig);
        this.workQueue = new WorkQueue("ClusterController", 10);
        this.timer = new Timer(true);
        ClusterTopology topology = ClusterControllerService.computeClusterTopology(this.ccConfig);
        this.ccContext = new ClusterControllerContext(topology);
        this.sweeper = new DeadNodeSweeper();
        this.resultDirectoryService = new ResultDirectoryService(this.ccConfig.getResultTTL(), this.ccConfig.getResultSweepThreshold());
        this.deploymentRunMap = new HashMap<DeploymentId, DeploymentRun>();
        this.stateDumpRunMap = new HashMap<String, GatherStateDumpsWork.StateDumpRun>();
        this.threadDumpRunMap = Collections.synchronizedMap(new HashMap());
        this.nodeManager = new NodeManager(this, this.ccConfig, this.resourceManager, application.getGatekeeper());
        this.ccId = this.ccConfig.getCcId();
        this.jobIdFactory = new JobIdFactory(this.ccId);
        this.deployedJobSpecIdFactory = new DeployedJobSpecIdFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClusterTopology computeClusterTopology(CCConfig ccConfig) throws Exception {
        if (ccConfig.getClusterTopology() == null) {
            return null;
        }
        FileReader fr = new FileReader(ccConfig.getClusterTopology());
        InputSource in = new InputSource(fr);
        try {
            ClusterTopology clusterTopology = TopologyDefinitionParser.parse((InputSource)in);
            return clusterTopology;
        }
        finally {
            fr.close();
        }
    }

    public String getId() {
        return "ClusterControllerService";
    }

    public void start() throws Exception {
        LOGGER.log(Level.INFO, "Starting ClusterControllerService: " + this);
        this.serverCtx = new ServerContext(IServerContext.ServerType.CLUSTER_CONTROLLER, new File(this.ccConfig.getRootDir()));
        ClusterControllerIPCI ccIPCI = new ClusterControllerIPCI(this);
        this.clusterIPC = new IPCSystem(new InetSocketAddress(this.ccConfig.getClusterListenAddress(), this.ccConfig.getClusterListenPort()), this.networkSecurityManager.getSocketChannelFactory(), (IIPCI)ccIPCI, (IPayloadSerializerDeserializer)new CCNCFunctions.SerializerDeserializer());
        ClientInterfaceIPCI ciIPCI = new ClientInterfaceIPCI(this, this.jobIdFactory);
        this.clientIPC = new IPCSystem(new InetSocketAddress(this.ccConfig.getClientListenAddress(), this.ccConfig.getClientListenPort()), this.networkSecurityManager.getSocketChannelFactory(), (IIPCI)ciIPCI, (IPayloadSerializerDeserializer)new JavaSerializationBasedPayloadSerializerDeserializer());
        this.clusterIPC.start();
        this.clientIPC.start();
        this.startWebServers();
        this.info = new ClusterControllerInfo(this.ccId, this.ccConfig.getClientPublicAddress(), this.ccConfig.getClientPublicPort(), this.ccConfig.getConsolePublicPort());
        this.timer.schedule((TimerTask)this.sweeper, 0L, this.ccConfig.getDeadNodeSweepThreshold());
        this.jobLog.open();
        this.startApplication();
        this.resultDirectoryService.init(this.executor, this.application.getJobResultCallback());
        this.workQueue.start();
        this.connectNCs();
        LOGGER.log(Level.INFO, "Started ClusterControllerService");
        this.notifyApplication();
    }

    protected void startWebServers() throws Exception {
        this.webServer = new WebServer(this, this.ccConfig.getConsoleListenPort());
        this.webServer.start();
    }

    private void startApplication() throws Exception {
        this.serviceCtx = new CCServiceContext(this, this.serverCtx, this.ccContext, this.ccConfig.getAppConfig());
        this.serviceCtx.addJobLifecycleListener(this.resultDirectoryService);
        this.application.init((IServiceContext)this.serviceCtx);
        this.executor = MaintainedThreadNameExecutorService.newCachedThreadPool((ThreadFactory)this.serviceCtx.getThreadFactory());
        this.application.start(this.ccConfig.getAppArgsArray());
        IJobCapacityController jobCapacityController = this.application.getJobCapacityController();
        try {
            Constructor<?> jobManagerConstructor = this.getClass().getClassLoader().loadClass(this.ccConfig.getJobManagerClass()).getConstructor(CCConfig.class, ClusterControllerService.class, IJobCapacityController.class);
            this.jobManager = (IJobManager)jobManagerConstructor.newInstance(this.ccConfig, this, jobCapacityController);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.log(Level.WARN, "class " + this.ccConfig.getJobManagerClass() + " could not be used: ", (Throwable)e);
            }
            this.jobManager = new JobManager(this.ccConfig, this, jobCapacityController);
        }
    }

    private InetSocketAddress getNCService(String nodeId) {
        IApplicationConfig ncConfig = this.configManager.getNodeEffectiveConfig(nodeId);
        int port = ncConfig.getInt((IOption)NCConfig.Option.NCSERVICE_PORT);
        return port == -1 ? null : InetSocketAddress.createUnresolved(ncConfig.getString((IOption)NCConfig.Option.NCSERVICE_ADDRESS), port);
    }

    private Map<String, InetSocketAddress> getNCServices() {
        TreeMap<String, InetSocketAddress> ncMap = new TreeMap<String, InetSocketAddress>();
        for (String ncId : this.configManager.getNodeNames()) {
            InetSocketAddress ncService = this.getNCService(ncId);
            if (ncService == null) continue;
            ncMap.put(ncId, ncService);
        }
        return ncMap;
    }

    private void connectNCs() {
        this.getNCServices().forEach((key, value) -> {
            TriggerNCWork triggerWork = new TriggerNCWork(this, value.getHostString(), value.getPort(), (String)key);
            this.executor.submit((Runnable)((Object)triggerWork));
        });
    }

    public boolean startNC(String nodeId) {
        InetSocketAddress ncServiceAddress = this.getNCService(nodeId);
        if (ncServiceAddress == null) {
            return false;
        }
        TriggerNCWork startNc = new TriggerNCWork(this, ncServiceAddress.getHostString(), ncServiceAddress.getPort(), nodeId);
        this.executor.submit((Runnable)((Object)startNc));
        return true;
    }

    private void terminateNCServices() throws Exception {
        ArrayList shutdownNCServiceWorks = new ArrayList();
        this.getNCServices().forEach((key, value) -> {
            ShutdownNCServiceWork shutdownWork = new ShutdownNCServiceWork(value.getHostString(), value.getPort(), (String)key);
            this.workQueue.schedule((AbstractWork)shutdownWork);
            shutdownNCServiceWorks.add(shutdownWork);
        });
        for (ShutdownNCServiceWork shutdownWork : shutdownNCServiceWorks) {
            shutdownWork.sync();
        }
    }

    private void notifyApplication() throws Exception {
        this.application.startupCompleted();
    }

    public void stop(boolean terminateNCService) throws Exception {
        if (terminateNCService) {
            this.terminateNCServices();
        }
        this.stop();
    }

    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "Stopping ClusterControllerService");
        this.stopApplication();
        this.stopWebServers();
        this.sweeper.cancel();
        this.workQueue.stop();
        this.executor.shutdownNow();
        this.clusterIPC.stop();
        this.jobLog.close();
        this.clientIPC.stop();
        LOGGER.log(Level.INFO, "Stopped ClusterControllerService");
    }

    protected void stopWebServers() throws Exception {
        this.webServer.stop();
    }

    private void stopApplication() throws Exception {
        this.application.stop();
    }

    public ServerContext getServerContext() {
        return this.serverCtx;
    }

    public ICCContext getCCContext() {
        return this.ccContext;
    }

    public IJobManager getJobManager() {
        return this.jobManager;
    }

    public INodeManager getNodeManager() {
        return this.nodeManager;
    }

    public DeployedJobSpecStore getDeployedJobSpecStore() throws HyracksException {
        return this.deployedJobSpecStore;
    }

    public void removeJobParameterByteStore(JobId jobId) throws HyracksException {
        this.jobParameterByteStoreMap.remove(jobId);
    }

    public JobParameterByteStore createOrGetJobParameterByteStore(JobId jobId) throws HyracksException {
        JobParameterByteStore jpbs = this.jobParameterByteStoreMap.get(jobId);
        if (jpbs == null) {
            jpbs = new JobParameterByteStore();
            this.jobParameterByteStoreMap.put(jobId, jpbs);
        }
        return jpbs;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public LogFile getJobLogFile() {
        return this.jobLog;
    }

    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public CCConfig getConfig() {
        return this.ccConfig;
    }

    public CCServiceContext getContext() {
        return this.serviceCtx;
    }

    public ClusterControllerInfo getClusterControllerInfo() {
        return this.info;
    }

    public CCConfig getCCConfig() {
        return this.ccConfig;
    }

    public IPCSystem getClusterIPC() {
        return this.clusterIPC;
    }

    public NetworkAddress getResultDirectoryAddress() {
        return new NetworkAddress(this.ccConfig.getClientPublicAddress(), this.ccConfig.getClientPublicPort());
    }

    public JobIdFactory getJobIdFactory() {
        return this.jobIdFactory;
    }

    public DeployedJobSpecIdFactory getDeployedJobSpecIdFactory() {
        return this.deployedJobSpecIdFactory;
    }

    public CcId getCcId() {
        return this.ccId;
    }

    public IResultDirectoryService getResultDirectoryService() {
        return this.resultDirectoryService;
    }

    public synchronized void addStateDumpRun(String id, GatherStateDumpsWork.StateDumpRun sdr) {
        this.stateDumpRunMap.put(id, sdr);
    }

    public synchronized GatherStateDumpsWork.StateDumpRun getStateDumpRun(String id) {
        return this.stateDumpRunMap.get(id);
    }

    public synchronized void removeStateDumpRun(String id) {
        this.stateDumpRunMap.remove(id);
    }

    public synchronized void addDeploymentRun(DeploymentId deploymentKey, DeploymentRun dRun) {
        this.deploymentRunMap.put(deploymentKey, dRun);
    }

    public synchronized DeploymentRun getDeploymentRun(DeploymentId deploymentKey) {
        return this.deploymentRunMap.get(deploymentKey);
    }

    public synchronized void removeDeploymentRun(DeploymentId deploymentKey) {
        this.deploymentRunMap.remove(deploymentKey);
    }

    public synchronized void setShutdownRun(ShutdownRun sRun) {
        this.shutdownCallback = sRun;
    }

    public synchronized ShutdownRun getShutdownRun() {
        return this.shutdownCallback;
    }

    public void addThreadDumpRun(String requestKey, GetThreadDumpWork.ThreadDumpRun tdr) {
        this.threadDumpRunMap.put(requestKey, tdr);
    }

    public GetThreadDumpWork.ThreadDumpRun removeThreadDumpRun(String requestKey) {
        return this.threadDumpRunMap.remove(requestKey);
    }

    private static ICCApplication getApplication(CCConfig ccConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (ccConfig.getAppClass() != null) {
            Class<?> c = Class.forName(ccConfig.getAppClass());
            return (ICCApplication)c.newInstance();
        }
        return BaseCCApplication.INSTANCE;
    }

    public ICCApplication getApplication() {
        return this.application;
    }

    public Object getApplicationContext() {
        return this.application.getApplicationContext();
    }

    public INetworkSecurityManager getNetworkSecurityManager() {
        return this.networkSecurityManager;
    }

    protected INetworkSecurityConfig getNetworkSecurityConfig() {
        return NetworkSecurityConfig.of((boolean)this.ccConfig.isSslEnabled(), (String)this.ccConfig.getKeyStorePath(), (String)this.ccConfig.getKeyStorePassword(), (String)this.ccConfig.getTrustStorePath());
    }

    static {
        ExitUtil.init();
    }

    private final class ClusterControllerContext
    implements ICCContext {
        private final ClusterTopology topology;

        private ClusterControllerContext(ClusterTopology topology) {
            this.topology = topology;
        }

        public void getIPAddressNodeMap(Map<InetAddress, Set<String>> map) throws HyracksDataException {
            GetIpAddressNodeNameMapWork ginmw = new GetIpAddressNodeNameMapWork(ClusterControllerService.this.getNodeManager(), map);
            try {
                ClusterControllerService.this.workQueue.scheduleAndSync((SynchronizableWork)ginmw);
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }

        public ClusterControllerInfo getClusterControllerInfo() {
            return ClusterControllerService.this.info;
        }

        public ClusterTopology getClusterTopology() {
            return this.topology;
        }
    }

    private class DeadNodeSweeper
    extends TimerTask {
        private DeadNodeSweeper() {
        }

        @Override
        public void run() {
            ClusterControllerService.this.workQueue.schedule((AbstractWork)new RemoveDeadNodesWork(ClusterControllerService.this));
        }
    }
}

