/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.encoding;

import java.io.DataInput;
import java.io.IOException;

public class VarLenIntEncoderDecoder {
    public static final int BOUND_ONE_BYTE = 128;
    public static final int BOUND_TWO_BYTE = 16384;
    public static final int BOUND_THREE_BYTE = 0x200000;
    public static final int BOUND_FOUR_BYTE = 0x10000000;
    public static final int BOUND_FIVE_BYTE = Integer.MAX_VALUE;
    public static final int ENCODE_MASK = 127;
    public static final byte CONTINUE_CHUNK = -128;
    public static final byte DECODE_MASK = 127;

    public static int getBytesRequired(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("The length must be an non-negative value");
        }
        int byteCount = 0;
        while (length > 127) {
            length >>>= 7;
            ++byteCount;
        }
        return byteCount + 1;
    }

    public static int decode(DataInput in) throws IOException {
        int sum = 0;
        byte b = in.readByte();
        while ((b & 0xFFFFFF80) == -128) {
            sum = sum + (b & 0x7F) << 7;
            b = in.readByte();
        }
        return sum += b;
    }

    public static int decode(byte[] srcBytes, int startPos) {
        int sum = 0;
        while (startPos < srcBytes.length && (srcBytes[startPos] & 0xFFFFFF80) == -128) {
            sum = sum + (srcBytes[startPos] & 0x7F) << 7;
            ++startPos;
        }
        if (startPos >= srcBytes.length) {
            throw new IllegalStateException("Corrupted string bytes: trying to access entry " + startPos + " in a byte array of length " + srcBytes.length);
        }
        return sum += srcBytes[startPos];
    }

    public static int encode(int lengthVal, byte[] destBytes, int startPos) {
        int i;
        if (lengthVal < 0) {
            throw new IllegalArgumentException("The length must be an non-negative value");
        }
        int nextPos = startPos;
        while (lengthVal > 127) {
            destBytes[nextPos++] = (byte)(lengthVal & 0x7F);
            lengthVal >>>= 7;
        }
        destBytes[nextPos++] = (byte)lengthVal;
        int length = nextPos - startPos;
        for (i = 0; i < length / 2; ++i) {
            byte b = destBytes[startPos + i];
            destBytes[startPos + i] = (byte)(destBytes[startPos + length - 1 - i] | 0xFFFFFF80);
            destBytes[startPos + length - 1 - i] = (byte)(b | 0xFFFFFF80);
        }
        int n = startPos + i;
        destBytes[n] = (byte)(destBytes[n] | 0xFFFFFF80);
        int n2 = nextPos - 1;
        destBytes[n2] = (byte)(destBytes[n2] & 0x7F);
        return length;
    }

    public static VarLenIntDecoder createDecoder() {
        return new VarLenIntDecoder();
    }

    public static class VarLenIntDecoder {
        private byte[] bytes = null;
        private int pos = 0;

        public VarLenIntDecoder reset(byte[] bytes, int pos) {
            this.bytes = bytes;
            this.pos = pos;
            return this;
        }

        public int decode() {
            int sum = 0;
            while ((this.bytes[this.pos] & 0xFFFFFF80) == -128) {
                sum = sum + (this.bytes[this.pos] & 0x7F) << 7;
                ++this.pos;
            }
            return sum += this.bytes[this.pos++];
        }

        public int getPos() {
            return this.pos;
        }
    }
}

