/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.optimizer.rules.AbstractConditionExpressionRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class InlineAndRemoveRedundantBooleanExpressionsRule
extends AbstractConditionExpressionRule {
    @Override
    protected boolean transform(Mutable<ILogicalExpression> condRef) {
        AbstractFunctionCallExpression function = this.getFunctionExpression((ILogicalExpression)condRef.getValue());
        if (function == null) {
            return false;
        }
        boolean changed = false;
        for (Mutable argRef : function.getArguments()) {
            changed |= this.transform((Mutable<ILogicalExpression>)argRef);
        }
        FunctionIdentifier fid = function.getFunctionIdentifier();
        if (AlgebricksBuiltinFunctions.AND.equals((Object)fid) || AlgebricksBuiltinFunctions.OR.equals((Object)fid)) {
            changed |= this.inlineCondition(function);
            changed |= this.removeRedundantExpressions(function.getArguments());
            if (function.getArguments().size() == 1) {
                ILogicalExpression newCond = (ILogicalExpression)((Mutable)function.getArguments().get(0)).getValue();
                condRef.setValue((Object)newCond);
            }
        }
        return changed;
    }

    private boolean inlineCondition(AbstractFunctionCallExpression function) {
        FunctionIdentifier fid = function.getFunctionIdentifier();
        List args = function.getArguments();
        int i = 0;
        boolean changed = false;
        while (i < args.size()) {
            AbstractFunctionCallExpression argFunction = this.getFunctionExpression((ILogicalExpression)((Mutable)args.get(i)).getValue());
            if (argFunction != null && fid.equals((Object)argFunction.getFunctionIdentifier())) {
                args.remove(i);
                args.addAll(i, argFunction.getArguments());
                changed = true;
                continue;
            }
            ++i;
        }
        return changed;
    }

    private boolean removeRedundantExpressions(List<Mutable<ILogicalExpression>> exprs) {
        int originalSize = exprs.size();
        for (int i = 0; i < exprs.size(); ++i) {
            int j = i + 1;
            while (j < exprs.size()) {
                if (FunctionUtil.commutativeEquals((ILogicalExpression)((ILogicalExpression)exprs.get(i).getValue()), (ILogicalExpression)((ILogicalExpression)exprs.get(j).getValue()))) {
                    exprs.remove(j);
                    continue;
                }
                ++j;
            }
        }
        return exprs.size() != originalSize;
    }
}

