/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.io.Closeable;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.app.nc.HaltCallback;
import org.apache.asterix.app.nc.IndexCheckpointManagerProvider;
import org.apache.asterix.app.nc.NCExtensionManager;
import org.apache.asterix.app.nc.ReplicaManager;
import org.apache.asterix.app.nc.TransactionSubsystem;
import org.apache.asterix.app.result.ResultReader;
import org.apache.asterix.common.api.IConfigValidator;
import org.apache.asterix.common.api.IConfigValidatorFactory;
import org.apache.asterix.common.api.ICoordinationService;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.IDiskWriteRateLimiterProvider;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.api.IPropertiesFactory;
import org.apache.asterix.common.api.IReceptionist;
import org.apache.asterix.common.api.IReceptionistFactory;
import org.apache.asterix.common.config.ActiveProperties;
import org.apache.asterix.common.config.BuildProperties;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.context.DatasetLifecycleManager;
import org.apache.asterix.common.context.DiskWriteRateLimiterProvider;
import org.apache.asterix.common.context.GlobalVirtualBufferCache;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.replication.IReplicationChannel;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.IReplicationStrategyFactory;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.IReplicaManager;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.common.transactions.IRecoveryManagerFactory;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.external.library.ExternalLibraryManager;
import org.apache.asterix.file.StorageComponentProvider;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.RMIClientFactory;
import org.apache.asterix.metadata.RMIServerFactory;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataBootstrap;
import org.apache.asterix.replication.management.ReplicationChannel;
import org.apache.asterix.replication.management.ReplicationManager;
import org.apache.asterix.runtime.transaction.GlobalResourceIdFactoryProvider;
import org.apache.asterix.runtime.utils.NoOpCoordinationService;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepositoryFactory;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.client.ClusterControllerInfo;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.client.result.ResultSet;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.ipc.impl.HyracksConnection;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.AsynchronousScheduler;
import org.apache.hyracks.storage.am.lsm.common.impls.ConcurrentMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.GreedyScheduler;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.ClockPageReplacementStrategy;
import org.apache.hyracks.storage.common.buffercache.DelayPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.HeapBufferAllocator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.IPageCleanerPolicy;
import org.apache.hyracks.storage.common.buffercache.IPageReplacementStrategy;
import org.apache.hyracks.storage.common.file.FileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;
import org.apache.hyracks.util.MaintainedThreadNameExecutorService;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.hyracks.util.cache.CacheManager;
import org.apache.hyracks.util.cache.ICacheManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCAppRuntimeContext
implements INcApplicationContext {
    private static final Logger LOGGER = LogManager.getLogger();
    private ILSMMergePolicyFactory metadataMergePolicyFactory;
    private final INCServiceContext ncServiceContext;
    private final IResourceIdFactory resourceIdFactory;
    private final CompilerProperties compilerProperties;
    private final ExternalProperties externalProperties;
    private final MetadataProperties metadataProperties;
    private final StorageProperties storageProperties;
    private final TransactionProperties txnProperties;
    private final ActiveProperties activeProperties;
    private final BuildProperties buildProperties;
    private final ReplicationProperties replicationProperties;
    private final MessagingProperties messagingProperties;
    private final NodeProperties nodeProperties;
    private ExecutorService threadExecutor;
    private IDatasetLifecycleManager datasetLifecycleManager;
    private IBufferCache bufferCache;
    private IVirtualBufferCache virtualBufferCache;
    private ITransactionSubsystem txnSubsystem;
    private IMetadataNode metadataNodeStub;
    private ILSMIOOperationScheduler lsmIOScheduler;
    private PersistentLocalResourceRepository localResourceRepository;
    private IIOManager ioManager;
    private boolean isShuttingdown;
    private ActiveManager activeManager;
    private IReplicationChannel replicationChannel;
    private IReplicationManager replicationManager;
    private ExternalLibraryManager libraryManager;
    private final NCExtensionManager ncExtensionManager;
    private final IStorageComponentProvider componentProvider;
    private final IPersistedResourceRegistry persistedResourceRegistry;
    private volatile HyracksConnection hcc;
    private volatile ResultSet resultSet;
    private IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    private IReplicaManager replicaManager;
    private IReceptionist receptionist;
    private ICacheManager cacheManager;
    private IConfigValidator configValidator;
    private IDiskWriteRateLimiterProvider diskWriteRateLimiterProvider;

    public NCAppRuntimeContext(INCServiceContext ncServiceContext, NCExtensionManager extensionManager, IPropertiesFactory propertiesFactory) {
        this.ncServiceContext = ncServiceContext;
        this.compilerProperties = propertiesFactory.newCompilerProperties();
        this.externalProperties = propertiesFactory.newExternalProperties();
        this.metadataProperties = propertiesFactory.newMetadataProperties();
        this.storageProperties = propertiesFactory.newStorageProperties();
        this.txnProperties = propertiesFactory.newTransactionProperties();
        this.activeProperties = propertiesFactory.newActiveProperties();
        this.buildProperties = propertiesFactory.newBuildProperties();
        this.replicationProperties = propertiesFactory.newReplicationProperties();
        this.messagingProperties = propertiesFactory.newMessagingProperties();
        this.nodeProperties = propertiesFactory.newNodeProperties();
        this.ncExtensionManager = extensionManager;
        this.componentProvider = new StorageComponentProvider();
        this.resourceIdFactory = new GlobalResourceIdFactoryProvider(ncServiceContext).createResourceIdFactory();
        this.persistedResourceRegistry = ncServiceContext.getPersistedResourceRegistry();
        this.cacheManager = new CacheManager();
    }

    public void initialize(IRecoveryManagerFactory recoveryManagerFactory, IReceptionistFactory receptionistFactory, IConfigValidatorFactory configValidatorFactory, IReplicationStrategyFactory replicationStrategyFactory, boolean initialRun) throws IOException {
        int maxScheduledFlushes;
        boolean resetStorageData;
        this.ioManager = this.getServiceContext().getIoManager();
        int ioQueueLen = this.getServiceContext().getAppConfig().getInt((IOption)NCConfig.Option.IO_QUEUE_SIZE);
        this.threadExecutor = MaintainedThreadNameExecutorService.newCachedThreadPool((ThreadFactory)this.getServiceContext().getThreadFactory());
        HeapBufferAllocator allocator = new HeapBufferAllocator();
        DelayPageCleanerPolicy pcp = new DelayPageCleanerPolicy(600000L);
        ClockPageReplacementStrategy prs = new ClockPageReplacementStrategy((ICacheMemoryAllocator)allocator, this.storageProperties.getBufferCachePageSize(), this.storageProperties.getBufferCacheNumPages());
        this.lsmIOScheduler = this.createIoScheduler(this.storageProperties);
        this.metadataMergePolicyFactory = new ConcurrentMergePolicyFactory();
        this.indexCheckpointManagerProvider = new IndexCheckpointManagerProvider(this.ioManager);
        PersistentLocalResourceRepositoryFactory persistentLocalResourceRepositoryFactory = new PersistentLocalResourceRepositoryFactory(this.ioManager, this.indexCheckpointManagerProvider, this.persistedResourceRegistry);
        this.localResourceRepository = (PersistentLocalResourceRepository)persistentLocalResourceRepositoryFactory.createRepository();
        this.configValidator = configValidatorFactory.create();
        this.txnSubsystem = new TransactionSubsystem(this, recoveryManagerFactory);
        IRecoveryManager recoveryMgr = this.txnSubsystem.getRecoveryManager();
        IRecoveryManager.SystemState systemState = recoveryMgr.getSystemState();
        boolean bl = resetStorageData = initialRun || systemState == IRecoveryManager.SystemState.PERMANENT_DATA_LOSS;
        if (resetStorageData) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.log(Level.WARN, "Deleting the storage dir. initialRun = " + initialRun + ", systemState = " + systemState);
            }
            this.localResourceRepository.deleteStorageData();
        }
        if ((maxScheduledFlushes = this.storageProperties.getMaxScheduledFlushes()) <= 0) {
            maxScheduledFlushes = this.ioManager.getIODevices().size();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The value of maxScheduledFlushes is not provided. Setting maxConcurrentFlushes = {}.", (Object)maxScheduledFlushes);
            }
        }
        this.virtualBufferCache = new GlobalVirtualBufferCache((ICacheMemoryAllocator)allocator, this.storageProperties, maxScheduledFlushes);
        ((ILifeCycleComponent)this.virtualBufferCache).start();
        this.datasetLifecycleManager = new DatasetLifecycleManager(this.storageProperties, (ILocalResourceRepository)this.localResourceRepository, this.txnSubsystem.getLogManager(), this.virtualBufferCache, this.indexCheckpointManagerProvider, this.ioManager.getIODevices().size());
        String nodeId = this.getServiceContext().getNodeId();
        Set nodePartitions = this.metadataProperties.getNodePartitions(nodeId);
        this.replicaManager = new ReplicaManager(this, nodePartitions);
        this.isShuttingdown = false;
        this.activeManager = new ActiveManager(this.threadExecutor, this.getServiceContext().getNodeId(), this.activeProperties.getMemoryComponentGlobalBudget(), this.compilerProperties.getFrameSize(), this.ncServiceContext);
        this.receptionist = receptionistFactory.create();
        if (this.replicationProperties.isReplicationEnabled()) {
            this.replicationManager = new ReplicationManager((INcApplicationContext)this, replicationStrategyFactory, this.replicationProperties);
            this.txnSubsystem.getLogManager().setReplicationManager(this.replicationManager);
            this.localResourceRepository.setReplicationManager(this.replicationManager);
            this.replicationChannel = new ReplicationChannel((INcApplicationContext)this);
            this.bufferCache = new BufferCache(this.ioManager, (IPageReplacementStrategy)prs, (IPageCleanerPolicy)pcp, (IFileMapManager)new FileMapManager(), this.storageProperties.getBufferCacheMaxOpenFiles(), ioQueueLen, this.getServiceContext().getThreadFactory(), (IIOReplicationManager)this.replicationManager);
        } else {
            this.bufferCache = new BufferCache(this.ioManager, (IPageReplacementStrategy)prs, (IPageCleanerPolicy)pcp, (IFileMapManager)new FileMapManager(), this.storageProperties.getBufferCacheMaxOpenFiles(), ioQueueLen, this.getServiceContext().getThreadFactory());
        }
        NodeControllerService ncs = (NodeControllerService)this.getServiceContext().getControllerService();
        FileReference appDir = this.ioManager.resolveAbsolutePath(this.getServiceContext().getServerCtx().getAppDir().getAbsolutePath());
        this.libraryManager = new ExternalLibraryManager(ncs, this.persistedResourceRegistry, appDir, this.ioManager);
        this.libraryManager.initialize(resetStorageData);
        ILifeCycleComponentManager lccm = this.getServiceContext().getLifeCycleComponentManager();
        lccm.register((ILifeCycleComponent)this.virtualBufferCache);
        lccm.register((ILifeCycleComponent)this.bufferCache);
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getLogManager());
        if (this.replicationManager != null) {
            lccm.register((ILifeCycleComponent)this.replicationManager);
        }
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getRecoveryManager());
        lccm.register((ILifeCycleComponent)this.datasetLifecycleManager);
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getTransactionManager());
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getLockManager());
        lccm.register((ILifeCycleComponent)this.txnSubsystem.getCheckpointManager());
        lccm.register((ILifeCycleComponent)this.libraryManager);
        this.diskWriteRateLimiterProvider = new DiskWriteRateLimiterProvider();
    }

    public boolean isShuttingdown() {
        return this.isShuttingdown;
    }

    public void setShuttingdown(boolean isShuttingdown) {
        this.isShuttingdown = isShuttingdown;
    }

    public synchronized void preStop() throws Exception {
        this.activeManager.shutdown();
        if (this.metadataNodeStub != null) {
            this.unexportMetadataNodeStub();
        }
    }

    public void deinitialize() throws HyracksDataException {
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    public IVirtualBufferCache getVirtualBufferCache() {
        return this.virtualBufferCache;
    }

    public ITransactionSubsystem getTransactionSubsystem() {
        return this.txnSubsystem;
    }

    public IDatasetLifecycleManager getDatasetLifecycleManager() {
        return this.datasetLifecycleManager;
    }

    public ILSMIOOperationScheduler getLSMIOScheduler() {
        return this.lsmIOScheduler;
    }

    public ILocalResourceRepository getLocalResourceRepository() {
        return this.localResourceRepository;
    }

    public IResourceIdFactory getResourceIdFactory() {
        return this.resourceIdFactory;
    }

    public IIOManager getIoManager() {
        return this.ioManager;
    }

    public StorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public TransactionProperties getTransactionProperties() {
        return this.txnProperties;
    }

    public CompilerProperties getCompilerProperties() {
        return this.compilerProperties;
    }

    public MetadataProperties getMetadataProperties() {
        return this.metadataProperties;
    }

    public ExternalProperties getExternalProperties() {
        return this.externalProperties;
    }

    public ActiveProperties getActiveProperties() {
        return this.activeProperties;
    }

    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    public MessagingProperties getMessagingProperties() {
        return this.messagingProperties;
    }

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    public ExecutorService getThreadExecutor() {
        return this.threadExecutor;
    }

    public ILSMMergePolicyFactory getMetadataMergePolicyFactory() {
        return this.metadataMergePolicyFactory;
    }

    public ActiveManager getActiveManager() {
        return this.activeManager;
    }

    public ReplicationProperties getReplicationProperties() {
        return this.replicationProperties;
    }

    public IReplicationChannel getReplicationChannel() {
        return this.replicationChannel;
    }

    public IReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    public ILibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public void initializeMetadata(boolean newUniverse, int partitionId) throws Exception {
        LOGGER.info("Bootstrapping metadata");
        MetadataNode.INSTANCE.initialize((INcApplicationContext)this, this.ncExtensionManager.getMetadataTupleTranslatorProvider(), this.ncExtensionManager.getMetadataExtensions(), partitionId);
        ConcurrentHashMap proxyMap = (ConcurrentHashMap)this.getServiceContext().getDistributedState();
        if (proxyMap == null) {
            throw new IllegalStateException("Metadata node cannot access distributed state");
        }
        MetadataManager.initialize(proxyMap.values(), (MetadataNode)MetadataNode.INSTANCE);
        MetadataBootstrap.startUniverse((INCServiceContext)this.getServiceContext(), (boolean)newUniverse);
        MetadataBootstrap.startDDLRecovery();
        this.ncExtensionManager.initializeMetadata(this.getServiceContext());
        LOGGER.info("Metadata node bound");
    }

    public synchronized void exportMetadataNodeStub() throws RemoteException {
        if (this.metadataNodeStub == null) {
            INetworkSecurityManager networkSecurityManager = this.ncServiceContext.getControllerService().getNetworkSecurityManager();
            if (networkSecurityManager.getConfiguration().isSslEnabled()) {
                RMIServerFactory serverSocketFactory = new RMIServerFactory(networkSecurityManager);
                RMIClientFactory clientSocketFactory = new RMIClientFactory(networkSecurityManager.getConfiguration());
                this.metadataNodeStub = (IMetadataNode)UnicastRemoteObject.exportObject((Remote)MetadataNode.INSTANCE, this.getMetadataProperties().getMetadataPort(), (RMIClientSocketFactory)clientSocketFactory, (RMIServerSocketFactory)serverSocketFactory);
            } else {
                this.metadataNodeStub = (IMetadataNode)UnicastRemoteObject.exportObject((Remote)MetadataNode.INSTANCE, this.getMetadataProperties().getMetadataPort());
            }
        }
    }

    public synchronized void unexportMetadataNodeStub() throws RemoteException {
        if (this.metadataNodeStub != null) {
            UnicastRemoteObject.unexportObject((Remote)MetadataNode.INSTANCE, false);
        }
        this.metadataNodeStub = null;
    }

    public synchronized void bindMetadataNodeStub(CcId ccId) throws RemoteException {
        if (this.metadataNodeStub == null) {
            throw new IllegalStateException("Metadata node not exported");
        }
        ((IAsterixStateProxy)((ConcurrentMap)((Object)this.getServiceContext().getDistributedState())).get(ccId)).setMetadataNode(this.metadataNodeStub);
    }

    public NCExtensionManager getExtensionManager() {
        return this.ncExtensionManager;
    }

    public IStorageComponentProvider getStorageComponentProvider() {
        return this.componentProvider;
    }

    public INCServiceContext getServiceContext() {
        return this.ncServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHyracksClientConnection getHcc() throws HyracksDataException {
        HyracksConnection hc = this.hcc;
        if (hc == null || !hc.isConnected()) {
            NCAppRuntimeContext nCAppRuntimeContext = this;
            synchronized (nCAppRuntimeContext) {
                hc = this.hcc;
                if (hc == null || !hc.isConnected()) {
                    try {
                        ResultSet rs = this.resultSet;
                        this.resultSet = null;
                        NetworkUtil.closeQuietly((Closeable)rs);
                        NodeControllerService ncSrv = (NodeControllerService)this.ncServiceContext.getControllerService();
                        CcId primaryCcId = ncSrv.getPrimaryCcId();
                        ClusterControllerInfo ccInfo = ncSrv.getNodeParameters(primaryCcId).getClusterControllerInfo();
                        NetworkUtil.closeQuietly((Closeable)hc);
                        this.hcc = hc = new HyracksConnection(ccInfo.getClientNetAddress(), ccInfo.getClientNetPort(), ncSrv.getNetworkSecurityManager().getSocketChannelFactory());
                    }
                    catch (Exception e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            }
        }
        return hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet getResultSet() throws HyracksDataException {
        ResultSet rs = this.resultSet;
        if (rs == null) {
            NCAppRuntimeContext nCAppRuntimeContext = this;
            synchronized (nCAppRuntimeContext) {
                rs = this.resultSet;
                if (rs == null) {
                    try {
                        this.resultSet = rs = ResultReader.createResultSet(this.getHcc(), this.ncServiceContext.getControllerService(), this.compilerProperties);
                    }
                    catch (Exception e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            }
        }
        return rs;
    }

    public IReplicaManager getReplicaManager() {
        return this.replicaManager;
    }

    public IIndexCheckpointManagerProvider getIndexCheckpointManagerProvider() {
        return this.indexCheckpointManagerProvider;
    }

    public ICoordinationService getCoordinationService() {
        return NoOpCoordinationService.INSTANCE;
    }

    public long getMaxTxnId() {
        if (this.txnSubsystem == null) {
            throw new IllegalStateException("cannot determine max txn id before txnSubsystem is initialized!");
        }
        return Math.max(MetadataManager.INSTANCE == null ? 0L : MetadataManager.INSTANCE.getMaxTxnId(), this.txnSubsystem.getTransactionManager().getMaxTxnId());
    }

    public IPersistedResourceRegistry getPersistedResourceRegistry() {
        return this.persistedResourceRegistry;
    }

    public IReceptionist getReceptionist() {
        return this.receptionist;
    }

    public ICacheManager getCacheManager() {
        return this.cacheManager;
    }

    public IConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    private ILSMIOOperationScheduler createIoScheduler(StorageProperties properties) {
        String schedulerName = this.storageProperties.getIoScheduler();
        int numPartitions = this.ioManager.getIODevices().size();
        int maxConcurrentFlushes = this.storageProperties.geMaxConcurrentFlushes(numPartitions);
        int maxScheduledMerges = this.storageProperties.getMaxScheduledMerges(numPartitions);
        int maxConcurrentMerges = this.storageProperties.getMaxConcurrentMerges(numPartitions);
        ILSMIOOperationScheduler ioScheduler = null;
        if (AsynchronousScheduler.FACTORY.getName().equalsIgnoreCase(schedulerName)) {
            ioScheduler = AsynchronousScheduler.FACTORY.createIoScheduler(this.getServiceContext().getThreadFactory(), (IIoOperationFailedCallback)HaltCallback.INSTANCE, maxConcurrentFlushes, maxScheduledMerges, maxConcurrentMerges);
        } else if (GreedyScheduler.FACTORY.getName().equalsIgnoreCase(schedulerName)) {
            ioScheduler = GreedyScheduler.FACTORY.createIoScheduler(this.getServiceContext().getThreadFactory(), (IIoOperationFailedCallback)HaltCallback.INSTANCE, maxConcurrentFlushes, maxScheduledMerges, maxConcurrentMerges);
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.log(Level.WARN, "Unknown storage I/O scheduler: " + schedulerName + "; defaulting to greedy I/O scheduler.");
            }
            ioScheduler = GreedyScheduler.FACTORY.createIoScheduler(this.getServiceContext().getThreadFactory(), (IIoOperationFailedCallback)HaltCallback.INSTANCE, maxConcurrentFlushes, maxScheduledMerges, maxConcurrentMerges);
        }
        return ioScheduler;
    }

    public IDiskWriteRateLimiterProvider getDiskWriteRateLimiterProvider() {
        return this.diskWriteRateLimiterProvider;
    }
}

