/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableYearMonthDuration;
import org.apache.asterix.om.base.AYearMonthDuration;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.ADurationParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractYearMonthDurationConstructorEvaluator
extends AbstractConstructorEvaluator {
    private final AMutableYearMonthDuration aYearMonthDuration = new AMutableYearMonthDuration(0);
    private final ISerializerDeserializer<AYearMonthDuration> yearMonthDurationSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AYEARMONTHDURATION);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractYearMonthDurationConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case YEARMONTHDURATION: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case DURATION: {
                int months = ADurationSerializerDeserializer.getYearMonth((byte[])bytes, (int)(startOffset + 1));
                this.aYearMonthDuration.setMonths(months);
                this.resultStorage.reset();
                this.yearMonthDurationSerde.serialize((Object)this.aYearMonthDuration, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (AbstractYearMonthDurationConstructorEvaluator.parseYearMonthDuration(this.utf8Ptr, this.aYearMonthDuration)) {
                    this.resultStorage.reset();
                    this.yearMonthDurationSerde.serialize((Object)this.aYearMonthDuration, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.AYEARMONTHDURATION;
    }

    private static boolean parseYearMonthDuration(UTF8StringPointable textPtr, AMutableYearMonthDuration result) {
        try {
            ADurationParserFactory.parseDuration((byte[])textPtr.getByteArray(), (int)textPtr.getCharStartOffset(), (int)textPtr.getUTF8Length(), (IAObject)result, (ADurationParserFactory.ADurationParseOption)ADurationParserFactory.ADurationParseOption.YEAR_MONTH);
            return true;
        }
        catch (HyracksDataException e) {
            return false;
        }
    }
}

