/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.util.Iterator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceLeftOuterJoinForSubplanRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return false;
        }
        SubplanOperator subplan = (SubplanOperator)op0;
        Iterator plansIter = subplan.getNestedPlans().iterator();
        ILogicalPlan p = null;
        while (plansIter.hasNext()) {
            p = (ILogicalPlan)plansIter.next();
        }
        if (p == null) {
            return false;
        }
        if (p.getRoots().size() != 1) {
            return false;
        }
        Mutable subplanRoot = (Mutable)p.getRoots().get(0);
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)subplanRoot.getValue();
        Mutable opUnder = (Mutable)subplan.getInputs().get(0);
        if (IntroduceLeftOuterJoinForSubplanRule.isMissingTest((AbstractLogicalOperator)opUnder.getValue())) {
            return false;
        }
        switch (op1.getOperatorTag()) {
            case INNERJOIN: {
                InnerJoinOperator join = (InnerJoinOperator)op1;
                Mutable leftRef = (Mutable)join.getInputs().get(0);
                Mutable rightRef = (Mutable)join.getInputs().get(1);
                Mutable<ILogicalOperator> ntsRef = this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)leftRef);
                if (ntsRef == null) {
                    ntsRef = this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)rightRef);
                    if (ntsRef == null) {
                        return false;
                    }
                    Mutable t = leftRef;
                    leftRef = rightRef;
                    rightRef = t;
                }
                ntsRef.setValue((Object)((ILogicalOperator)opUnder.getValue()));
                LeftOuterJoinOperator loj = new LeftOuterJoinOperator(join.getCondition(), ConstantExpression.MISSING.getValue());
                loj.setSourceLocation(join.getSourceLocation());
                loj.getInputs().add(leftRef);
                loj.getInputs().add(rightRef);
                opRef.setValue((Object)loj);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)loj);
                return true;
            }
            case LEFTOUTERJOIN: {
                LeftOuterJoinOperator join = (LeftOuterJoinOperator)op1;
                Mutable leftRef = (Mutable)join.getInputs().get(0);
                Mutable<ILogicalOperator> ntsRef = this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)leftRef);
                if (ntsRef == null) {
                    return false;
                }
                ntsRef.setValue((Object)((ILogicalOperator)opUnder.getValue()));
                opRef.setValue((Object)join);
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)join);
                return true;
            }
        }
        return false;
    }

    private Mutable<ILogicalOperator> getNtsAtEndOfPipeline(Mutable<ILogicalOperator> opRef) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return opRef;
        }
        if (op.getInputs().size() != 1) {
            return null;
        }
        return this.getNtsAtEndOfPipeline((Mutable<ILogicalOperator>)((Mutable)op.getInputs().get(0)));
    }

    public static boolean isMissingTest(AbstractLogicalOperator op) {
        if (op.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        AbstractLogicalOperator doubleUnder = (AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        if (doubleUnder.getOperatorTag() != LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return false;
        }
        ILogicalExpression eu = (ILogicalExpression)((SelectOperator)op).getCondition().getValue();
        if (eu.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f1 = (AbstractFunctionCallExpression)eu;
        if (!f1.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.NOT)) {
            return false;
        }
        ILogicalExpression a1 = (ILogicalExpression)((Mutable)f1.getArguments().get(0)).getValue();
        if (!a1.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            return false;
        }
        AbstractFunctionCallExpression f2 = (AbstractFunctionCallExpression)a1;
        return f2.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.IS_MISSING);
    }
}

