/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.apache.asterix.external.api.ILookupRecordReader;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractHDFSLookupRecordReader<T>
implements ILookupRecordReader<T> {
    protected int fileId;
    private ExternalFileIndexAccessor snapshotAccessor;
    protected ExternalFile file;
    protected FileSystem fs;
    protected Configuration conf;
    protected boolean replaced;

    public AbstractHDFSLookupRecordReader(ExternalFileIndexAccessor snapshotAccessor, FileSystem fs, Configuration conf) {
        this.snapshotAccessor = snapshotAccessor;
        this.fs = fs;
        this.conf = conf;
        this.fileId = -1;
        this.file = new ExternalFile();
    }

    @Override
    public void configure(Map<String, String> configurations) throws Exception {
    }

    @Override
    public IRawRecord<T> read(RecordId rid) throws Exception {
        if (rid.getFileId() != this.fileId) {
            this.closeFile();
            this.snapshotAccessor.lookup(rid.getFileId(), this.file);
            this.fileId = rid.getFileId();
            try {
                this.validate();
                if (!this.replaced) {
                    this.openFile();
                    this.validate();
                    if (this.replaced) {
                        this.closeFile();
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.replaced = true;
            }
        }
        if (this.replaced) {
            return null;
        }
        return this.lookup(rid);
    }

    protected abstract IRawRecord<T> lookup(RecordId var1) throws IOException;

    private void validate() throws IllegalArgumentException, IOException {
        FileStatus fileStatus = this.fs.getFileStatus(new Path(this.file.getFileName()));
        this.replaced = fileStatus.getModificationTime() != this.file.getLastModefiedTime().getTime();
    }

    protected abstract void closeFile();

    protected abstract void openFile() throws IllegalArgumentException, IOException;

    @Override
    public final void open() throws HyracksDataException {
        this.snapshotAccessor.open();
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeFile();
        }
        finally {
            this.snapshotAccessor.close();
        }
    }

    @Override
    public void fail() {
    }
}

