/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.invertedlist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.asterix.fuzzyjoin.invertedlist.InvertedList;

public class InvertedListLengthList
implements InvertedList {
    private LinkedList<ListLength> list = new LinkedList();

    @Override
    public void add(int[] element) {
        if (!this.list.isEmpty() && this.list.getLast().length == element[2]) {
            this.list.getLast().list.add(element);
        } else {
            ListLength listLength = new ListLength();
            listLength.length = element[2];
            listLength.list.add(element);
            this.list.add(listLength);
        }
    }

    @Override
    public Iterator<int[]> iterator() {
        return new ListIterator();
    }

    @Override
    public void setMinLength(int minLength) {
        while (!this.list.isEmpty() && this.list.getFirst().length < minLength) {
            this.list.removeFirst();
        }
    }

    public String toString() {
        return this.list.toString();
    }

    private class ListLength {
        public int length;
        public ArrayList<int[]> list = new ArrayList();

        private ListLength() {
        }

        public String toString() {
            StringBuffer l = new StringBuffer("(");
            for (int[] i : this.list) {
                l.append(Arrays.toString(i));
                l.append(",");
            }
            l.append(")");
            return "(length:" + this.length + "," + l + ")";
        }
    }

    private class ListIterator
    implements Iterator<int[]> {
        private final Iterator<ListLength> iteratorLength;
        private Iterator<int[]> iteratorList;

        public ListIterator() {
            this.iteratorLength = InvertedListLengthList.this.list.iterator();
            this.iteratorList = null;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorList != null && this.iteratorList.hasNext() || this.iteratorLength.hasNext();
        }

        @Override
        public int[] next() {
            if (this.iteratorList != null && this.iteratorList.hasNext()) {
                return this.iteratorList.next();
            }
            this.iteratorList = this.iteratorLength.next().list.iterator();
            return this.iteratorList.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

