/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.normalizers;

import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyProperties;
import org.apache.hyracks.data.std.primitive.IntegerPointable;

public class FloatNormalizedKeyComputerFactory
implements INormalizedKeyComputerFactory {
    private static final long serialVersionUID = 1L;
    public static final INormalizedKeyProperties PROPERTIES = new INormalizedKeyProperties(){
        private static final long serialVersionUID = 1L;

        public int getNormalizedKeyLength() {
            return 1;
        }

        public boolean isDecisive() {
            return true;
        }
    };

    public INormalizedKeyComputer createNormalizedKeyComputer() {
        return new INormalizedKeyComputer(){

            public void normalize(byte[] bytes, int start, int length, int[] normalizedKeys, int keyStart) {
                int value = IntegerPointable.getInteger((byte[])bytes, (int)start);
                normalizedKeys[keyStart] = value >= 0 ? value ^ Integer.MIN_VALUE : ~value;
            }

            public INormalizedKeyProperties getNormalizedKeyProperties() {
                return PROPERTIES;
            }
        };
    }

    public INormalizedKeyProperties getNormalizedKeyProperties() {
        return PROPERTIES;
    }
}

