/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition.range;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.dataflow.common.data.partition.range.AbstractFieldRangePartitionComputerFactory;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMapSupplier;

public final class FieldRangePartitionComputerFactory
extends AbstractFieldRangePartitionComputerFactory
implements ITuplePartitionComputerFactory {
    private static final long serialVersionUID = 2L;
    private final int[] rangeFields;
    private final boolean usePercentage;

    public FieldRangePartitionComputerFactory(int[] rangeFields, IBinaryComparatorFactory[] comparatorFactories, RangeMapSupplier rangeMapSupplier, SourceLocation sourceLocation, boolean usePercentage) {
        super(rangeMapSupplier, comparatorFactories, sourceLocation);
        this.rangeFields = rangeFields;
        this.usePercentage = usePercentage;
    }

    public ITuplePartitionComputer createPartitioner(IHyracksTaskContext taskContext) {
        return new AbstractFieldRangePartitionComputerFactory.AbstractFieldRangeSinglePartitionComputer(taskContext, this.usePercentage ? () -> new AbstractFieldRangePartitionComputerFactory.PercentageRangeMapPartitionComputer() : () -> new AbstractFieldRangePartitionComputerFactory.RangeMapPartitionComputer()){

            @Override
            protected int computePartition(IFrameTupleAccessor accessor, int tIndex, int nParts) throws HyracksDataException {
                return this.rangeMapPartitionComputer.partition(accessor, tIndex, FieldRangePartitionComputerFactory.this.rangeFields, nParts);
            }
        };
    }
}

