/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ImmutableDatasetId;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryHashFunctionFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.io.FileReference;

public class MetadataIndex
implements IMetadataIndex {
    private static final long serialVersionUID = 1L;
    protected final String datasetName;
    protected final String indexName;
    protected final IAType[] keyTypes;
    protected final List<List<String>> keyNames;
    protected final int[] fieldPermutation;
    protected final int[] bloomFilterKeyFields;
    protected final ARecordType payloadType;
    protected final RecordDescriptor recDesc;
    protected final ITypeTraits[] typeTraits;
    protected final IBinaryComparatorFactory[] bcfs;
    protected final IBinaryHashFunctionFactory[] bhffs;
    protected FileReference file;
    protected int fileId;
    protected long resourceId;
    private final DatasetId datasetId;
    protected final boolean isPrimaryIndex;
    protected final int[] primaryKeyIndexes;

    public MetadataIndex(MetadataIndexImmutableProperties indexImmutableProperties, int numFields, IAType[] keyTypes, List<List<String>> keyNames, int numSecondaryIndexKeys, ARecordType payloadType, boolean isPrimaryIndex, int[] primaryKeyIndexes) {
        int i;
        if (keyTypes.length != keyNames.size()) {
            throw new AssertionError((Object)"Unequal number of key names and key types");
        }
        if (keyTypes.length > numFields) {
            throw new AssertionError((Object)"Key size is larger than total number of fields");
        }
        this.datasetName = indexImmutableProperties.getDatasetName();
        this.indexName = indexImmutableProperties.getIndexName();
        this.keyTypes = keyTypes;
        this.keyNames = keyNames;
        this.payloadType = payloadType;
        this.fieldPermutation = new int[numFields];
        for (int i2 = 0; i2 < numFields; ++i2) {
            this.fieldPermutation[i2] = i2;
        }
        ISerializerDeserializer[] serdes = new ISerializerDeserializer[numFields];
        for (i = 0; i < keyTypes.length; ++i) {
            serdes[i] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)keyTypes[i]);
        }
        if (this.fieldPermutation.length > keyTypes.length) {
            serdes[numFields - 1] = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)payloadType);
        }
        this.recDesc = new RecordDescriptor(serdes);
        this.typeTraits = new ITypeTraits[this.fieldPermutation.length];
        for (i = 0; i < keyTypes.length; ++i) {
            this.typeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyTypes[i]);
        }
        if (this.fieldPermutation.length > keyTypes.length) {
            this.typeTraits[this.fieldPermutation.length - 1] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)payloadType);
        }
        this.bcfs = new IBinaryComparatorFactory[keyTypes.length];
        for (i = 0; i < keyTypes.length; ++i) {
            this.bcfs[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyTypes[i], true);
        }
        this.bhffs = new IBinaryHashFunctionFactory[keyTypes.length];
        for (i = 0; i < keyTypes.length; ++i) {
            this.bhffs[i] = BinaryHashFunctionFactoryProvider.INSTANCE.getBinaryHashFunctionFactory((Object)keyTypes[i]);
        }
        if (isPrimaryIndex) {
            this.bloomFilterKeyFields = new int[primaryKeyIndexes.length];
            for (i = 0; i < primaryKeyIndexes.length; ++i) {
                this.bloomFilterKeyFields[i] = primaryKeyIndexes[i];
            }
        } else {
            this.bloomFilterKeyFields = new int[numSecondaryIndexKeys];
            for (i = 0; i < numSecondaryIndexKeys; ++i) {
                this.bloomFilterKeyFields[i] = i;
            }
        }
        this.datasetId = new ImmutableDatasetId(indexImmutableProperties.getDatasetId());
        this.isPrimaryIndex = isPrimaryIndex;
        this.primaryKeyIndexes = primaryKeyIndexes;
        this.resourceId = indexImmutableProperties.getResourceId();
    }

    @Override
    public String getIndexedDatasetName() {
        return this.datasetName;
    }

    @Override
    public int[] getFieldPermutation() {
        return this.fieldPermutation;
    }

    @Override
    public int[] getBloomFilterKeyFields() {
        return this.bloomFilterKeyFields;
    }

    @Override
    public int getKeyFieldCount() {
        return this.keyTypes.length;
    }

    @Override
    public int getFieldCount() {
        return this.fieldPermutation.length;
    }

    @Override
    public DataverseName getDataverseName() {
        return MetadataConstants.METADATA_DATAVERSE_NAME;
    }

    @Override
    public String getNodeGroupName() {
        return "MetadataGroup";
    }

    @Override
    public List<List<String>> getPartitioningExpr() {
        ArrayList<List<String>> partitioningExpr = new ArrayList<List<String>>();
        for (int i = 0; i < this.keyNames.size(); ++i) {
            partitioningExpr.add(this.keyNames.get(i));
        }
        return partitioningExpr;
    }

    @Override
    public List<IAType> getPartitioningExprType() {
        return Arrays.asList(this.keyTypes);
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public ITypeTraits[] getTypeTraits() {
        return this.typeTraits;
    }

    @Override
    public RecordDescriptor getRecordDescriptor() {
        return this.recDesc;
    }

    @Override
    public IBinaryComparatorFactory[] getKeyBinaryComparatorFactory() {
        return this.bcfs;
    }

    @Override
    public IBinaryHashFunctionFactory[] getKeyBinaryHashFunctionFactory() {
        return this.bhffs;
    }

    @Override
    public String getFileNameRelativePath() {
        return StoragePathUtil.prepareDataverseIndexName((DataverseName)this.getDataverseName(), (String)this.getIndexedDatasetName(), (String)this.getIndexName(), (long)0L);
    }

    @Override
    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    @Override
    public int getFileId() {
        return this.fileId;
    }

    @Override
    public ARecordType getPayloadRecordType() {
        return this.payloadType;
    }

    @Override
    public void setFile(FileReference file) {
        this.file = file;
    }

    @Override
    public FileReference getFile() {
        return this.file;
    }

    @Override
    public void setResourceId(long resourceID) {
        this.resourceId = resourceID;
    }

    @Override
    public long getResourceId() {
        return this.resourceId;
    }

    @Override
    public DatasetId getDatasetId() {
        return this.datasetId;
    }

    @Override
    public boolean isPrimaryIndex() {
        return this.isPrimaryIndex;
    }

    @Override
    public int[] getPrimaryKeyIndexes() {
        return this.primaryKeyIndexes;
    }
}

