/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ComponentMaskTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.util.ThreadDumpUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class MarkComponentValidTask
implements IReplicaTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final long masterLsn;
    private final long lastComponentId;
    private final String file;
    private final String masterNodeId;

    public MarkComponentValidTask(String file, long masterLsn, long lastComponentId, String masterNodeId) {
        this.file = file;
        this.lastComponentId = lastComponentId;
        this.masterLsn = masterLsn;
        this.masterNodeId = masterNodeId;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            if (this.masterLsn == -2L) {
                this.updateBulkLoadedLastComponentSequence(appCtx);
            } else if (this.masterLsn != -1L) {
                this.ensureComponentLsnFlushed(appCtx);
            }
            Path maskPath = ComponentMaskTask.getComponentMaskPath(appCtx, this.file);
            Files.delete(maskPath);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException | InterruptedException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private void updateBulkLoadedLastComponentSequence(INcApplicationContext appCtx) throws HyracksDataException {
        ResourceReference indexRef = ResourceReference.of((String)this.file);
        IIndexCheckpointManagerProvider checkpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        IIndexCheckpointManager indexCheckpointManager = checkpointManagerProvider.get(indexRef);
        long componentSequence = IndexComponentFileReference.of((String)indexRef.getName()).getSequenceEnd();
        indexCheckpointManager.advanceValidComponent(componentSequence, this.lastComponentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureComponentLsnFlushed(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        ResourceReference indexRef = ResourceReference.of((String)this.file);
        IIndexCheckpointManagerProvider checkpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        IIndexCheckpointManager indexCheckpointManager = checkpointManagerProvider.get(indexRef);
        long replicationTimeOut = TimeUnit.SECONDS.toMillis(appCtx.getReplicationProperties().getReplicationTimeOut());
        IIndexCheckpointManager iIndexCheckpointManager = indexCheckpointManager;
        synchronized (iIndexCheckpointManager) {
            while (!indexCheckpointManager.isFlushed(this.masterLsn)) {
                if (replicationTimeOut <= 0L) {
                    LOGGER.warn("{} seconds passed without receiving flush lsn {} from master for component {}", (Object)appCtx.getReplicationProperties().getReplicationTimeOut(), (Object)this.masterLsn, (Object)this.file);
                    LOGGER.debug("thead dump on receiving flush lsn timeout {}", new Supplier[]{ThreadDumpUtil::takeDumpString});
                    throw new ReplicationException((Throwable)new TimeoutException("couldn't receive flush lsn from master"));
                }
                long startTime = System.nanoTime();
                indexCheckpointManager.wait(replicationTimeOut);
                replicationTimeOut -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            }
            long componentSequence = IndexComponentFileReference.of((String)indexRef.getName()).getSequenceEnd();
            indexCheckpointManager.replicated(componentSequence, this.masterLsn, this.lastComponentId, this.masterNodeId);
        }
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.MARK_COMPONENT_VALID;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
            dos.writeLong(this.masterLsn);
            dos.writeLong(this.lastComponentId);
            boolean hasMaster = this.masterNodeId != null;
            dos.writeBoolean(hasMaster);
            if (hasMaster) {
                dos.writeUTF(this.masterNodeId);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static MarkComponentValidTask create(DataInput input) throws IOException {
        String indexFile = input.readUTF();
        long lsn = input.readLong();
        long lastComponentId = input.readLong();
        boolean hasMaster = input.readBoolean();
        String masterNodeId = hasMaster ? input.readUTF() : null;
        return new MarkComponentValidTask(indexFile, lsn, lastComponentId, masterNodeId);
    }
}

