/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.annotation.ExcludeFromSelectStarAnnotation;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateWithConditionClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class SqlppRightJoinRewriteVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final LangRewritingContext context;
    private final Collection<VarIdentifier> externalVars;

    public SqlppRightJoinRewriteVisitor(LangRewritingContext context, Collection<VarIdentifier> externalVars) {
        this.context = context;
        this.externalVars = externalVars;
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        FromTerm fromTerm;
        List<FromTerm> fromTerms;
        super.visit(selectBlock, arg);
        if (selectBlock.hasFromClause() && (fromTerms = selectBlock.getFromClause().getFromTerms()).size() == 1 && this.canRewriteFromTerm(fromTerm = fromTerms.get(0))) {
            Pair<FromTerm, List<LetClause>> newFromLetPair = this.rewriteFromTerm(fromTerm);
            fromTerms.set(0, (FromTerm)((Object)newFromLetPair.first));
            selectBlock.getLetWhereList().addAll(0, (Collection)newFromLetPair.second);
        }
        return null;
    }

    private boolean canRewriteFromTerm(FromTerm fromTerm) throws CompilationException {
        boolean hasRightOuterJoin = false;
        List<AbstractBinaryCorrelateClause> clauseList = fromTerm.getCorrelateClauses();
        for (AbstractBinaryCorrelateClause correlateClause : clauseList) {
            JoinClause joinClause;
            if (correlateClause.getClauseType() != Clause.ClauseType.JOIN_CLAUSE || (joinClause = (JoinClause)correlateClause).getJoinType() != JoinType.RIGHTOUTER) continue;
            hasRightOuterJoin = true;
            break;
        }
        if (!hasRightOuterJoin) {
            return false;
        }
        Set<VariableExpr> fromExprFreeVars = SqlppVariableUtil.getFreeVariables((ILangExpression)fromTerm.getLeftExpression());
        for (VariableExpr freeVarExpr : fromExprFreeVars) {
            if (this.externalVars.contains(freeVarExpr.getVar())) continue;
            return false;
        }
        return true;
    }

    private Pair<FromTerm, List<LetClause>> rewriteFromTerm(FromTerm fromTerm) throws CompilationException {
        HashMap<VariableExpr, VariableExpr> substMapInner = new HashMap<VariableExpr, VariableExpr>();
        HashMap<VariableExpr, Expression> substMapOuterTmp = new HashMap<VariableExpr, Expression>();
        LinkedHashMap<VariableExpr, Expression> substMapOuterFinal = new LinkedHashMap<VariableExpr, Expression>();
        Expression fromExpr = fromTerm.getLeftExpression();
        VariableExpr fromVar = fromTerm.getLeftVariable();
        VariableExpr fromPosVar = fromTerm.getPositionalVariable();
        List<AbstractBinaryCorrelateClause> correlateClauses = fromTerm.getCorrelateClauses();
        block8: for (int i = 0; i < correlateClauses.size(); ++i) {
            AbstractBinaryCorrelateClause correlateClause = correlateClauses.get(i);
            if (correlateClause.getClauseType() == Clause.ClauseType.JOIN_CLAUSE && ((JoinClause)correlateClause).getJoinType() == JoinType.RIGHTOUTER) {
                JoinClause joinClause = (JoinClause)correlateClause;
                SourceLocation joinClauseSourceLoc = joinClause.getSourceLocation();
                Expression rightExpr = joinClause.getRightExpression();
                VariableExpr rightVar = joinClause.getRightVariable();
                VariableExpr rightPosVar = joinClause.getPositionalVariable();
                Expression condExpr = joinClause.getConditionExpression();
                Literal.Type outerMissingValueType = joinClause.getOuterJoinMissingValueType();
                if (i == 0) {
                    JoinClause newJoinClause = new JoinClause(JoinType.LEFTOUTER, fromExpr, fromVar, fromPosVar, condExpr, outerMissingValueType);
                    newJoinClause.setSourceLocation(joinClauseSourceLoc);
                    fromExpr = rightExpr;
                    fromVar = rightVar;
                    fromPosVar = rightPosVar;
                    correlateClauses.set(i, newJoinClause);
                    continue;
                }
                VarIdentifier newRightVar = this.context.newVariable();
                substMapOuterTmp.clear();
                substMapInner.clear();
                ArrayList<Projection> projectList = new ArrayList<Projection>();
                SourceLocation fromVarSourceLoc = fromVar.getSourceLocation();
                VarIdentifier newFromVar = this.context.newVariable();
                String newFromVarFieldName = this.generateFieldName();
                projectList.add(this.createProjection(this.newVariableExpr(newFromVar, fromVarSourceLoc), newFromVarFieldName, fromVarSourceLoc));
                substMapOuterTmp.put(fromVar, SqlppRewriteUtil.getFieldByName((Expression)this.newVariableExpr(newRightVar, fromVarSourceLoc), newFromVarFieldName));
                substMapInner.put(fromVar, this.newVariableExpr(newFromVar, fromVarSourceLoc));
                VarIdentifier newFromPosVar = null;
                if (fromPosVar != null) {
                    SourceLocation fromPosVarSourceLoc = fromPosVar.getSourceLocation();
                    newFromPosVar = this.context.newVariable();
                    String newFromPosVarFieldName = this.generateFieldName();
                    projectList.add(this.createProjection(this.newVariableExpr(newFromPosVar, fromPosVarSourceLoc), newFromPosVarFieldName, fromPosVarSourceLoc));
                    substMapOuterTmp.put(fromPosVar, SqlppRewriteUtil.getFieldByName((Expression)this.newVariableExpr(newRightVar, fromPosVarSourceLoc), newFromPosVarFieldName));
                    substMapInner.put(fromPosVar, this.newVariableExpr(newFromPosVar, fromPosVarSourceLoc));
                }
                ArrayList<AbstractBinaryCorrelateClause> newPrecedingClauseList = new ArrayList<AbstractBinaryCorrelateClause>(i);
                for (int j = 0; j < i; ++j) {
                    AbstractBinaryCorrelateClause newPrecedingClause;
                    AbstractBinaryCorrelateClause precedingClause = correlateClauses.get(j);
                    SourceLocation precedingClauseSourceLoc = precedingClause.getSourceLocation();
                    VariableExpr precedingClauseRightVar = precedingClause.getRightVariable();
                    SourceLocation precedingClauseRightVarSourceLoc = precedingClauseRightVar.getSourceLocation();
                    VarIdentifier newPrecedingClauseRightVar = this.context.newVariable();
                    String newPrecedingClauseRightVarFieldName = this.generateFieldName();
                    projectList.add(this.createProjection(this.newVariableExpr(newPrecedingClauseRightVar, precedingClauseRightVarSourceLoc), newPrecedingClauseRightVarFieldName, precedingClauseRightVarSourceLoc));
                    substMapOuterTmp.put(precedingClauseRightVar, SqlppRewriteUtil.getFieldByName((Expression)this.newVariableExpr(newRightVar, precedingClauseRightVarSourceLoc), newPrecedingClauseRightVarFieldName));
                    substMapInner.put(precedingClauseRightVar, this.newVariableExpr(newPrecedingClauseRightVar, precedingClauseRightVarSourceLoc));
                    VariableExpr precedingClauseRightPosVar = precedingClause.getPositionalVariable();
                    SourceLocation precedingClauseRightPosVarSourceLoc = null;
                    VarIdentifier newPrecedingClauseRightPosVar = null;
                    if (precedingClauseRightPosVar != null) {
                        precedingClauseRightPosVarSourceLoc = precedingClauseRightPosVar.getSourceLocation();
                        newPrecedingClauseRightPosVar = this.context.newVariable();
                        String newPrecedingClauseRightPosVarFieldName = this.generateFieldName();
                        projectList.add(this.createProjection(this.newVariableExpr(newPrecedingClauseRightPosVar, precedingClauseRightPosVarSourceLoc), newPrecedingClauseRightPosVarFieldName, precedingClauseRightPosVarSourceLoc));
                        substMapOuterTmp.put(precedingClauseRightPosVar, SqlppRewriteUtil.getFieldByName((Expression)this.newVariableExpr(newRightVar, precedingClauseRightPosVarSourceLoc), newPrecedingClauseRightPosVarFieldName));
                        substMapInner.put(precedingClauseRightPosVar, this.newVariableExpr(newPrecedingClauseRightPosVar, precedingClauseRightPosVarSourceLoc));
                    }
                    switch (precedingClause.getClauseType()) {
                        case JOIN_CLAUSE: {
                            JoinClause joinPrecedingClause = (JoinClause)precedingClause;
                            Expression newCondExpr = (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)joinPrecedingClause.getConditionExpression());
                            SqlppRewriteUtil.substituteExpression(newCondExpr, substMapInner, this.context);
                            newPrecedingClause = new JoinClause(joinPrecedingClause.getJoinType(), joinPrecedingClause.getRightExpression(), this.newVariableExpr(newPrecedingClauseRightVar, precedingClauseRightVarSourceLoc), newPrecedingClauseRightPosVar != null ? this.newVariableExpr(newPrecedingClauseRightPosVar, precedingClauseRightPosVarSourceLoc) : null, newCondExpr, joinPrecedingClause.getOuterJoinMissingValueType());
                            newPrecedingClause.setSourceLocation(precedingClauseSourceLoc);
                            break;
                        }
                        case UNNEST_CLAUSE: {
                            UnnestClause unnestPrecedingClause = (UnnestClause)precedingClause;
                            Expression newRightExpr = (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)unnestPrecedingClause.getRightExpression());
                            SqlppRewriteUtil.substituteExpression(newRightExpr, substMapInner, this.context);
                            newPrecedingClause = new UnnestClause(unnestPrecedingClause.getUnnestType(), newRightExpr, this.newVariableExpr(newPrecedingClauseRightVar, precedingClauseRightVarSourceLoc), newPrecedingClauseRightPosVar != null ? this.newVariableExpr(newPrecedingClauseRightPosVar, precedingClauseRightPosVarSourceLoc) : null, unnestPrecedingClause.getOuterUnnestMissingValueType());
                            newPrecedingClause.setSourceLocation(precedingClauseSourceLoc);
                            break;
                        }
                        default: {
                            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{String.valueOf(precedingClause.getClauseType())});
                        }
                    }
                    newPrecedingClauseList.add(newPrecedingClause);
                }
                Expression newRightExpr = this.createRightSelectExpression(fromExpr, newFromVar, newFromPosVar, newPrecedingClauseList, projectList, joinClauseSourceLoc);
                VariableExpr newRightVarExpr = this.newVariableExpr(newRightVar, rightVar.getSourceLocation());
                newRightVarExpr.addHint((IExpressionAnnotation)ExcludeFromSelectStarAnnotation.INSTANCE);
                for (VariableExpr varExpr : substMapOuterFinal.keySet()) {
                    Expression substExpr = (Expression)substMapOuterFinal.get(varExpr);
                    Expression newSubstExpr = SqlppRewriteUtil.substituteExpression(substExpr, substMapOuterTmp, this.context);
                    substMapOuterFinal.put(varExpr, newSubstExpr);
                }
                substMapOuterFinal.putAll(substMapOuterTmp);
                Expression newCondExpr = SqlppRewriteUtil.substituteExpression((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)condExpr), substMapOuterFinal, this.context);
                JoinClause newJoinClause = new JoinClause(JoinType.LEFTOUTER, newRightExpr, newRightVarExpr, null, newCondExpr, outerMissingValueType);
                newJoinClause.setSourceLocation(joinClauseSourceLoc);
                fromExpr = rightExpr;
                fromVar = rightVar;
                fromPosVar = rightPosVar;
                correlateClauses.subList(0, i).clear();
                correlateClauses.set(0, newJoinClause);
                i = 0;
                continue;
            }
            if (substMapOuterFinal.isEmpty()) continue;
            switch (correlateClause.getClauseType()) {
                case JOIN_CLAUSE: {
                    AbstractBinaryCorrelateWithConditionClause correlateConditionClause = (AbstractBinaryCorrelateWithConditionClause)correlateClause;
                    Expression condExpr = correlateConditionClause.getConditionExpression();
                    Expression newCondExpr = SqlppRewriteUtil.substituteExpression((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)condExpr), substMapOuterFinal, this.context);
                    correlateConditionClause.setConditionExpression(newCondExpr);
                }
                case UNNEST_CLAUSE: {
                    Expression rightExpr = correlateClause.getRightExpression();
                    Expression newRightExpr = SqlppRewriteUtil.substituteExpression((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)rightExpr), substMapOuterFinal, this.context);
                    correlateClause.setRightExpression(newRightExpr);
                    continue block8;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, correlateClause.getSourceLocation(), new Serializable[]{String.valueOf(correlateClause.getClauseType())});
                }
            }
        }
        FromTerm newFromTerm = new FromTerm(fromExpr, fromVar, fromPosVar, correlateClauses);
        newFromTerm.setSourceLocation(fromTerm.getSourceLocation());
        ArrayList<LetClause> newLetClauses = new ArrayList<LetClause>(substMapOuterFinal.size());
        for (Map.Entry me : substMapOuterFinal.entrySet()) {
            VariableExpr newVarExpr = (VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)me.getKey());
            Expression newValueExpr = (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)me.getValue());
            LetClause newLetClause = new LetClause(newVarExpr, newValueExpr);
            newLetClause.setSourceLocation(newVarExpr.getSourceLocation());
            newLetClauses.add(newLetClause);
        }
        return new Pair((Object)newFromTerm, newLetClauses);
    }

    private Expression createRightSelectExpression(Expression fromExpr, VarIdentifier fromVar, VarIdentifier fromPosVar, List<AbstractBinaryCorrelateClause> correlateClauseList, List<Projection> projectList, SourceLocation sourceLoc) {
        FromTerm newFromTerm = new FromTerm(fromExpr, this.newVariableExpr(fromVar, sourceLoc), fromPosVar != null ? this.newVariableExpr(fromPosVar, sourceLoc) : null, correlateClauseList);
        ArrayList<FromTerm> newFromTermList = new ArrayList<FromTerm>(1);
        newFromTermList.add(newFromTerm);
        FromClause newFromClause = new FromClause(newFromTermList);
        newFromClause.setSourceLocation(sourceLoc);
        SelectClause newSelectClause = new SelectClause(null, new SelectRegular(projectList), false);
        newSelectClause.setSourceLocation(sourceLoc);
        SelectBlock newSelectBlock = new SelectBlock(newSelectClause, newFromClause, null, null, null);
        newSelectBlock.setSourceLocation(sourceLoc);
        SelectSetOperation newSelectSetOp = new SelectSetOperation(new SetOperationInput(newSelectBlock, null), null);
        newSelectSetOp.setSourceLocation(sourceLoc);
        SelectExpression newSelectExpr = new SelectExpression(null, newSelectSetOp, null, null, true);
        newSelectExpr.setSourceLocation(sourceLoc);
        return newSelectExpr;
    }

    private VariableExpr newVariableExpr(VarIdentifier newFromVar, SourceLocation sourceLoc) {
        VariableExpr varExpr = new VariableExpr(newFromVar);
        varExpr.setSourceLocation(sourceLoc);
        return varExpr;
    }

    private Projection createProjection(VariableExpr var, String fieldName, SourceLocation sourceLoc) {
        Projection projection = new Projection(Projection.Kind.NAMED_EXPR, (Expression)this.newVariableExpr(var.getVar(), null), fieldName);
        projection.setSourceLocation(sourceLoc);
        return projection;
    }

    private String generateFieldName() {
        return SqlppVariableUtil.variableNameToDisplayedFieldName(this.context.newVariable().getValue());
    }
}

