/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public final class CancelUnnestSingletonListRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        UnnestOperator unnest = (UnnestOperator)op;
        if (unnest.getPositionalVariable() != null) {
            return false;
        }
        ILogicalExpression expr = (ILogicalExpression)unnest.getExpressionRef().getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        if (((AbstractFunctionCallExpression)expr).getFunctionIdentifier() != BuiltinFunctions.SCAN_COLLECTION) {
            return false;
        }
        AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)expr;
        ILogicalExpression argExpr = (ILogicalExpression)((Mutable)callExpr.getArguments().get(0)).getValue();
        if (argExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        ConstantExpression cExpr = (ConstantExpression)argExpr;
        IAlgebricksConstantValue cValue = cExpr.getValue();
        if (!(cValue instanceof AsterixConstantValue)) {
            return false;
        }
        AsterixConstantValue aValue = (AsterixConstantValue)cValue;
        IAObject value = aValue.getObject();
        if (!value.getType().getTypeTag().isListType()) {
            return false;
        }
        IACollection list = (IACollection)value;
        if (list.size() != 1) {
            return false;
        }
        IACursor cur = list.getCursor();
        if (!cur.next()) {
            return false;
        }
        IAObject item = cur.get();
        ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>(1);
        assignVars.add(unnest.getVariable());
        ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>(1);
        ConstantExpression itemExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(item));
        itemExpr.setSourceLocation(cExpr.getSourceLocation());
        assignExprs.add(new MutableObject((Object)itemExpr));
        AssignOperator assignOp = new AssignOperator(assignVars, assignExprs);
        assignOp.setSourceLocation(op.getSourceLocation());
        assignOp.getInputs().addAll(op.getInputs());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        opRef.setValue((Object)assignOp);
        return true;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }
}

