/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import org.apache.asterix.common.annotations.SpatialJoinAnnotation;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class FilterRefineSpatialJoinRuleForSTDistanceFunction
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        Mutable joinConditionRef = joinOp.getCondition();
        ILogicalExpression joinCondition = (ILogicalExpression)joinConditionRef.getValue();
        if (joinCondition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)joinCondition;
        if (!(funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.LT) || funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.LE) || funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.EQ))) {
            return false;
        }
        List inputExprs = funcExpr.getArguments();
        ILogicalExpression leftOperatingExpr = (ILogicalExpression)((Mutable)inputExprs.get(0)).getValue();
        ILogicalExpression rightOperatingExpr = (ILogicalExpression)((Mutable)inputExprs.get(1)).getValue();
        if (leftOperatingExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || rightOperatingExpr.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return false;
        }
        AbstractFunctionCallExpression distanceFuncCallExpr = (AbstractFunctionCallExpression)leftOperatingExpr;
        ConstantExpression distanceValExpr = (ConstantExpression)rightOperatingExpr;
        if (!distanceFuncCallExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.ST_DISTANCE)) {
            return false;
        }
        List distanceFuncCallArgs = distanceFuncCallExpr.getArguments();
        Mutable distanceFuncCallLeftArg = (Mutable)distanceFuncCallArgs.get(0);
        Mutable distanceFuncCallRightArg = (Mutable)distanceFuncCallArgs.get(1);
        if (((ILogicalExpression)distanceFuncCallLeftArg.getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT || ((ILogicalExpression)distanceFuncCallRightArg.getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT) {
            return false;
        }
        IAlgebricksConstantValue distanceVal = distanceValExpr.getValue();
        ScalarFunctionCallExpression enlargedLeft = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.ST_MBR_ENLARGE), new Mutable[]{distanceFuncCallLeftArg, new MutableObject((Object)new ConstantExpression(distanceVal))});
        enlargedLeft.setSourceLocation(((ILogicalExpression)distanceFuncCallLeftArg.getValue()).getSourceLocation());
        ScalarFunctionCallExpression rightMBR = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.ST_MBR), new Mutable[]{distanceFuncCallRightArg});
        rightMBR.setSourceLocation(((ILogicalExpression)distanceFuncCallRightArg.getValue()).getSourceLocation());
        ScalarFunctionCallExpression spatialIntersect = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SPATIAL_INTERSECT), new Mutable[]{new MutableObject((Object)enlargedLeft.cloneExpression()), new MutableObject((Object)rightMBR.cloneExpression())});
        spatialIntersect.setSourceLocation(op.getSourceLocation());
        if (distanceFuncCallExpr.getAnnotation(SpatialJoinAnnotation.class) != null) {
            spatialIntersect.putAnnotation(distanceFuncCallExpr.getAnnotation(SpatialJoinAnnotation.class));
        }
        ScalarFunctionCallExpression updatedJoinCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), new Mutable[]{new MutableObject((Object)spatialIntersect), new MutableObject((Object)funcExpr)});
        updatedJoinCondition.setSourceLocation(op.getSourceLocation());
        joinConditionRef.setValue((Object)updatedJoinCondition);
        return true;
    }
}

