/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.subplan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.BroadcastSideSwitchingVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.IQueryOperatorVisitor;

class InlineLeftNtsInSubplanJoinFlatteningVisitor
implements IQueryOperatorVisitor<ILogicalOperator, Void> {
    private final IOptimizationContext context;
    private final ILogicalOperator subplanInputOperator;
    private final ILogicalOperator targetNts;
    private final IAlgebricksConstantValue leftOuterMissingValue;
    private final Set<LogicalVariable> liveVarsFromSubplanInput = new HashSet<LogicalVariable>();
    private boolean rewritten = false;
    private boolean hasJoinAncestor = false;
    private Set<LogicalVariable> nullCheckVars = new HashSet<LogicalVariable>();
    private Mutable<ILogicalOperator> topJoinRef;

    public InlineLeftNtsInSubplanJoinFlatteningVisitor(IOptimizationContext context, ILogicalOperator subplanInputOperator, ILogicalOperator nts, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        this.context = context;
        this.subplanInputOperator = subplanInputOperator;
        this.targetNts = nts;
        this.leftOuterMissingValue = Objects.requireNonNull(leftOuterMissingValue);
        VariableUtilities.getSubplanLocalLiveVariables((ILogicalOperator)subplanInputOperator, this.liveVarsFromSubplanInput);
    }

    public Set<LogicalVariable> getNullCheckVariables() {
        return this.nullCheckVars;
    }

    public Mutable<ILogicalOperator> getTopJoinReference() {
        return this.topJoinRef;
    }

    public ILogicalOperator visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        this.hasJoinAncestor = true;
        boolean needToSwitch = false;
        for (int i = 0; i < op.getInputs().size(); ++i) {
            ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(i)).getValue()).accept((ILogicalOperatorVisitor)this, null);
            ((Mutable)op.getInputs().get(i)).setValue((Object)newChild);
            if (i == 1) {
                needToSwitch = true;
            }
            if (this.rewritten) break;
        }
        if (this.rewritten && needToSwitch) {
            Mutable leftBranch = (Mutable)op.getInputs().get(0);
            Mutable rightBranch = (Mutable)op.getInputs().get(1);
            op.getInputs().set(0, rightBranch);
            op.getInputs().set(1, leftBranch);
            ((ILogicalExpression)op.getCondition().getValue()).accept((ILogicalExpressionVisitor)BroadcastSideSwitchingVisitor.getInstance(), null);
        }
        InnerJoinOperator returnOp = op;
        if (this.rewritten) {
            returnOp = new LeftOuterJoinOperator(op.getCondition(), this.leftOuterMissingValue);
            returnOp.setSourceLocation(op.getSourceLocation());
            returnOp.getInputs().addAll(op.getInputs());
            this.injectNullCheckVars((AbstractBinaryJoinOperator)returnOp);
        }
        return returnOp;
    }

    public ILogicalOperator visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        this.hasJoinAncestor = true;
        ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)this, null);
        ((Mutable)op.getInputs().get(0)).setValue((Object)newChild);
        return op;
    }

    public ILogicalOperator visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        if (op == this.targetNts) {
            this.rewritten = true;
            return this.subplanInputOperator;
        }
        return op;
    }

    public ILogicalOperator visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        boolean underJoin = this.hasJoinAncestor;
        this.visitSingleInputOperator((ILogicalOperator)op);
        if (!this.rewritten || !underJoin) {
            return op;
        }
        ArrayList<Pair> orderExprList = new ArrayList<Pair>();
        for (LogicalVariable liveVar : this.liveVarsFromSubplanInput) {
            VariableReferenceExpression liveVarRef = new VariableReferenceExpression(liveVar);
            liveVarRef.setSourceLocation(op.getSourceLocation());
            orderExprList.add(new Pair((Object)OrderOperator.ASC_ORDER, (Object)new MutableObject((Object)liveVarRef)));
        }
        orderExprList.addAll(op.getOrderExpressions());
        OrderOperator orderOp = new OrderOperator(orderExprList);
        orderOp.setSourceLocation(op.getSourceLocation());
        orderOp.getInputs().addAll(op.getInputs());
        this.context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)orderOp);
        return orderOp;
    }

    public ILogicalOperator visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        return op;
    }

    public ILogicalOperator visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        boolean underJoin = this.hasJoinAncestor;
        this.visitSingleInputOperator((ILogicalOperator)op);
        if (!this.rewritten || !underJoin) {
            return op;
        }
        for (LogicalVariable keyVar : this.liveVarsFromSubplanInput) {
            if (op.getVariables().contains(keyVar)) continue;
            op.getVariables().add(keyVar);
        }
        return op;
    }

    public ILogicalOperator visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        throw new UnsupportedOperationException("Script operators in a subplan are not supported!");
    }

    public ILogicalOperator visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        throw new UnsupportedOperationException("Nested subplans with a union operator should have been disqualified for this rewriting!");
    }

    public ILogicalOperator visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        throw new UnsupportedOperationException("Nested subplans with a intersect operator should have been disqualified for this rewriting!");
    }

    public ILogicalOperator visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitSingleInputOperator((ILogicalOperator)op);
        if (!this.rewritten) {
            return op;
        }
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVars);
        if (!liveVars.containsAll(this.liveVarsFromSubplanInput)) {
            op.setPropagatesInput(true);
        }
        return op;
    }

    public ILogicalOperator visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        throw new AlgebricksException("The subquery de-correlation rule should always be applied before index-access-method related rules.");
    }

    public ILogicalOperator visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        boolean underJoin = this.hasJoinAncestor;
        this.visitSingleInputOperator((ILogicalOperator)op);
        if (!this.rewritten || !underJoin) {
            return op;
        }
        for (LogicalVariable keyVar : this.liveVarsFromSubplanInput) {
            if (op.isDistinctByVar(keyVar)) continue;
            VariableReferenceExpression keyVarRef = new VariableReferenceExpression(keyVar);
            keyVarRef.setSourceLocation(op.getSourceLocation());
            op.getExpressions().add(new MutableObject((Object)keyVarRef));
        }
        this.context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        return op;
    }

    public ILogicalOperator visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    public ILogicalOperator visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        throw new UnsupportedOperationException("Nested subplans with a forward operator should have been disqualified for this rewriting!");
    }

    public ILogicalOperator visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        return this.visitSingleInputOperator((ILogicalOperator)op);
    }

    private ILogicalOperator visitSingleInputOperator(ILogicalOperator op) throws AlgebricksException {
        if (op.getInputs().size() == 1) {
            Mutable childRef = (Mutable)op.getInputs().get(0);
            ILogicalOperator newChild = (ILogicalOperator)((ILogicalOperator)childRef.getValue()).accept((ILogicalOperatorVisitor)this, null);
            LogicalOperatorTag childOpTag = newChild.getOperatorTag();
            if (childOpTag == LogicalOperatorTag.INNERJOIN || childOpTag == LogicalOperatorTag.LEFTOUTERJOIN) {
                this.topJoinRef = childRef;
            }
            ((Mutable)op.getInputs().get(0)).setValue((Object)newChild);
        }
        return op;
    }

    private void injectNullCheckVars(AbstractBinaryJoinOperator joinOp) {
        LogicalVariable assignVar = this.context.newVar();
        AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        assignOp.setSourceLocation(joinOp.getSourceLocation());
        assignOp.getInputs().add((Mutable)joinOp.getInputs().get(1));
        joinOp.getInputs().set(1, new MutableObject((Object)assignOp));
        this.nullCheckVars.add(assignVar);
    }
}

