/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.subplan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.subplan.SubplanFlatteningUtil;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class InlineSubplanInputForNestedTupleSourceRule
implements IAlgebraicRewriteRule {
    private boolean hasRun = false;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.rewriteSubplanOperator(opRef, context);
        this.hasRun = true;
        return (Boolean)result.first;
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> rewriteSubplanOperator(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> changedAndVarMap = this.traverseNonSubplanOperator((ILogicalOperator)op, context);
        if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
            return changedAndVarMap;
        }
        SubplanOperator subplanOp = (SubplanOperator)op;
        if (subplanOp.getNumberOfRoots() != 1) {
            return changedAndVarMap;
        }
        IAlgebricksConstantValue leftOuterMissingValue = ConstantExpression.MISSING.getValue();
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.applySpecialFlattening(opRef, context, leftOuterMissingValue);
        if (!((Boolean)result.first).booleanValue()) {
            result = this.applyGeneralFlattening(opRef, context, leftOuterMissingValue);
        }
        LinkedHashMap returnedMap = new LinkedHashMap();
        returnedMap.putAll((Map)changedAndVarMap.second);
        returnedMap.putAll((Map)result.second);
        return new Pair((Object)((Boolean)result.first != false || (Boolean)changedAndVarMap.first != false ? 1 : 0), returnedMap);
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> traverseNonSubplanOperator(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVars);
        LinkedHashMap replacedVarMap = new LinkedHashMap();
        LinkedHashMap replacedVarMapForAncestor = new LinkedHashMap();
        boolean changed = false;
        for (Mutable childrenRef : op.getInputs()) {
            Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> resultFromChild = this.rewriteSubplanOperator((Mutable<ILogicalOperator>)childrenRef, context);
            changed = changed || (Boolean)resultFromChild.first != false;
            ((LinkedHashMap)resultFromChild.second).forEach((oldVar, newVar) -> {
                if (liveVars.contains(oldVar)) {
                    replacedVarMapForAncestor.put(oldVar, newVar);
                    oldVar = newVar;
                    while ((newVar = (LogicalVariable)((LinkedHashMap)resultFromChild.second).get(newVar)) != null) {
                        replacedVarMapForAncestor.put(oldVar, newVar);
                        oldVar = newVar;
                    }
                }
            });
            replacedVarMap.putAll((Map)resultFromChild.second);
        }
        VariableUtilities.substituteVariables((ILogicalOperator)op, replacedVarMap, (ITypingContext)context);
        context.computeAndSetTypeEnvironmentForOperator(op);
        return new Pair((Object)changed, replacedVarMapForAncestor);
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> applyGeneralFlattening(Mutable<ILogicalOperator> opRef, IOptimizationContext context, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        ConstantExpression joinExpr;
        ILogicalOperator inputOp;
        SubplanOperator subplanOp = (SubplanOperator)opRef.getValue();
        if (!SubplanFlatteningUtil.containsOperators(subplanOp, EnumSet.of(LogicalOperatorTag.DATASOURCESCAN, LogicalOperatorTag.INNERJOIN, LogicalOperatorTag.LEFTOUTERJOIN))) {
            return new Pair((Object)false, new LinkedHashMap());
        }
        SourceLocation sourceLoc = subplanOp.getSourceLocation();
        Mutable inputOpRef = (Mutable)subplanOp.getInputs().get(0);
        ILogicalOperator inputOpBackup = (ILogicalOperator)inputOpRef.getValue();
        EquivalenceClassUtils.computePrimaryKeys(inputOpBackup, context);
        Triple<Set<LogicalVariable>, ILogicalOperator, FunctionalDependency> primaryOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(inputOpBackup, true, context);
        Set primaryKeyVars = (Set)primaryOpAndVars.first;
        FunctionalDependency newPrimaryKeyFd = null;
        if (primaryOpAndVars.second != null) {
            inputOp = (ILogicalOperator)primaryOpAndVars.second;
            inputOpRef.setValue((Object)inputOp);
            newPrimaryKeyFd = (FunctionalDependency)primaryOpAndVars.third;
        } else {
            inputOp = inputOpBackup;
        }
        HashSet inputLiveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)inputOp, inputLiveVars);
        Pair<Map<LogicalVariable, LogicalVariable>, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>> varMapAndOrderExprs = SubplanFlatteningUtil.inlineAllNestedTupleSource(subplanOp, context, newPrimaryKeyFd);
        Map varMap = (Map)varMapAndOrderExprs.first;
        if (varMap == null) {
            inputOpRef.setValue((Object)inputOpBackup);
            return new Pair((Object)false, new LinkedHashMap());
        }
        MutableObject lowestAggregateRefInSubplan = SubplanFlatteningUtil.findLowestAggregate((Mutable<ILogicalOperator>)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)));
        if (lowestAggregateRefInSubplan == null) {
            throw new CompilationException(ErrorCode.ILLEGAL_STATE, subplanOp.getSourceLocation(), new Serializable[0]);
        }
        Mutable rightInputOpRef = (Mutable)((ILogicalOperator)lowestAggregateRefInSubplan.getValue()).getInputs().get(0);
        ILogicalOperator rightInputOp = (ILogicalOperator)rightInputOpRef.getValue();
        LogicalVariable assignVar = context.newVar();
        AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        assignOp.setSourceLocation(rightInputOp.getSourceLocation());
        assignOp.getInputs().add(rightInputOpRef);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        rightInputOpRef = new MutableObject((Object)assignOp);
        ArrayList<MutableObject> joinPredicates = new ArrayList<MutableObject>();
        for (LogicalVariable liveVar : primaryKeyVars) {
            ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
            VariableReferenceExpression liveVarRef = new VariableReferenceExpression(liveVar);
            liveVarRef.setSourceLocation(sourceLoc);
            arguments.add(new MutableObject((Object)liveVarRef));
            LogicalVariable rightVar = (LogicalVariable)varMap.get(liveVar);
            VariableReferenceExpression rightVarRef = new VariableReferenceExpression(rightVar);
            rightVarRef.setSourceLocation(sourceLoc);
            arguments.add(new MutableObject((Object)rightVarRef));
            ScalarFunctionCallExpression expr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.EQ), arguments);
            expr.setSourceLocation(sourceLoc);
            joinPredicates.add(new MutableObject((Object)expr));
        }
        if (joinPredicates.size() > 1) {
            ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)AlgebricksBuiltinFunctions.AND), joinPredicates);
            andExpr.setSourceLocation(sourceLoc);
            joinExpr = andExpr;
        } else {
            joinExpr = joinPredicates.size() > 0 ? (ILogicalExpression)((Mutable)joinPredicates.get(0)).getValue() : ConstantExpression.TRUE;
        }
        LeftOuterJoinOperator leftOuterJoinOp = new LeftOuterJoinOperator((Mutable)new MutableObject((Object)joinExpr), inputOpRef, rightInputOpRef, leftOuterMissingValue);
        leftOuterJoinOp.setSourceLocation(sourceLoc);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)rightInputOp, (ITypingContext)context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)leftOuterJoinOp);
        ArrayList<Pair> groupByList = new ArrayList<Pair>();
        ArrayList<Pair> groupByDecorList = new ArrayList<Pair>();
        ArrayList<ALogicalPlanImpl> nestedPlans = new ArrayList<ALogicalPlanImpl>();
        GroupByOperator groupbyOp = new GroupByOperator(groupByList, groupByDecorList, nestedPlans);
        groupbyOp.setSourceLocation(sourceLoc);
        LinkedHashMap<LogicalVariable, LogicalVariable> replacedVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        for (LogicalVariable liveVar : primaryKeyVars) {
            LogicalVariable newVar = context.newVar();
            VariableReferenceExpression liveVarRef = new VariableReferenceExpression(liveVar);
            liveVarRef.setSourceLocation(inputOpBackup.getSourceLocation());
            groupByList.add(new Pair((Object)newVar, (Object)new MutableObject((Object)liveVarRef)));
            replacedVarMap.put(liveVar, newVar);
        }
        for (LogicalVariable liveVar : inputLiveVars) {
            if (primaryKeyVars.contains(liveVar)) continue;
            VariableReferenceExpression liveVarRef = new VariableReferenceExpression(liveVar);
            liveVarRef.setSourceLocation(sourceLoc);
            groupByDecorList.add(new Pair(null, (Object)new MutableObject((Object)liveVarRef)));
        }
        Mutable aggOpRef = (Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0);
        ((ILogicalOperator)lowestAggregateRefInSubplan.getValue()).getInputs().clear();
        MutableObject currentOpRef = lowestAggregateRefInSubplan;
        List orderExprs = (List)varMapAndOrderExprs.second;
        if (!orderExprs.isEmpty()) {
            OrderOperator orderOp = new OrderOperator(orderExprs);
            orderOp.setSourceLocation(sourceLoc);
            currentOpRef = new MutableObject((Object)orderOp);
            ((ILogicalOperator)lowestAggregateRefInSubplan.getValue()).getInputs().add(currentOpRef);
        }
        VariableReferenceExpression assignVarRef = new VariableReferenceExpression(assignVar);
        assignVarRef.setSourceLocation(sourceLoc);
        MutableObject filterVarExpr = new MutableObject((Object)assignVarRef);
        ArrayList<MutableObject> args = new ArrayList<MutableObject>();
        args.add(filterVarExpr);
        ArrayList<MutableObject> argsForNotFunction = new ArrayList<MutableObject>();
        ScalarFunctionCallExpression isMissingExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)OperatorPropertiesUtil.getIsMissingNullFunction((IAlgebricksConstantValue)leftOuterMissingValue)), args);
        isMissingExpr.setSourceLocation(sourceLoc);
        argsForNotFunction.add(new MutableObject((Object)isMissingExpr));
        ScalarFunctionCallExpression notExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), argsForNotFunction);
        notExpr.setSourceLocation(sourceLoc);
        SelectOperator selectOp = new SelectOperator((Mutable)new MutableObject((Object)notExpr));
        selectOp.setSourceLocation(sourceLoc);
        ((ILogicalOperator)currentOpRef.getValue()).getInputs().add(new MutableObject((Object)selectOp));
        NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)groupbyOp));
        ntsOp.setSourceLocation(sourceLoc);
        selectOp.getInputs().add(new MutableObject((Object)ntsOp));
        ArrayList<Mutable> nestedRoots = new ArrayList<Mutable>();
        nestedRoots.add(aggOpRef);
        nestedPlans.add(new ALogicalPlanImpl(nestedRoots));
        groupbyOp.getInputs().add(new MutableObject((Object)leftOuterJoinOp));
        opRef.setValue((Object)groupbyOp);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)groupbyOp, (ITypingContext)context);
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.rewriteSubplanOperator((Mutable<ILogicalOperator>)rightInputOpRef, context);
        VariableUtilities.substituteVariables((ILogicalOperator)leftOuterJoinOp, (Map)((Map)result.second), (ITypingContext)context);
        VariableUtilities.substituteVariables((ILogicalOperator)groupbyOp, (Map)((Map)result.second), (ITypingContext)context);
        return new Pair((Object)true, replacedVarMap);
    }

    private Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> applySpecialFlattening(Mutable<ILogicalOperator> opRef, IOptimizationContext context, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        ILogicalOperator inputOp;
        SubplanOperator subplanOp = (SubplanOperator)opRef.getValue();
        SourceLocation sourceLoc = subplanOp.getSourceLocation();
        Mutable inputOpRef = (Mutable)subplanOp.getInputs().get(0);
        LinkedHashMap<LogicalVariable, LogicalVariable> replacedVarMap = new LinkedHashMap<LogicalVariable, LogicalVariable>();
        Pair<Boolean, LinkedHashMap<LogicalVariable, LogicalVariable>> result = this.rewriteSubplanOperator((Mutable<ILogicalOperator>)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)), context);
        ILogicalOperator inputOpBackup = (ILogicalOperator)inputOpRef.getValue();
        EquivalenceClassUtils.computePrimaryKeys(inputOpBackup, context);
        Triple<Set<LogicalVariable>, ILogicalOperator, FunctionalDependency> primaryOpAndVars = EquivalenceClassUtils.findOrCreatePrimaryKeyOpAndVariables(inputOpBackup, false, context);
        Set primaryKeyVars = (Set)primaryOpAndVars.first;
        FunctionalDependency newPrimaryKeyFd = null;
        if (primaryOpAndVars.second != null) {
            inputOp = (ILogicalOperator)primaryOpAndVars.second;
            inputOpRef.setValue((Object)inputOp);
            newPrimaryKeyFd = (FunctionalDependency)primaryOpAndVars.third;
        } else {
            inputOp = inputOpBackup;
        }
        HashSet liveVars = new HashSet();
        VariableUtilities.getLiveVariables((ILogicalOperator)inputOp, liveVars);
        Pair<Set<LogicalVariable>, Mutable<ILogicalOperator>> notNullVarsAndTopJoinRef = SubplanFlatteningUtil.inlineLeftNtsInSubplanJoin(subplanOp, context, newPrimaryKeyFd, leftOuterMissingValue);
        if (notNullVarsAndTopJoinRef.first == null) {
            inputOpRef.setValue((Object)inputOpBackup);
            return new Pair((Object)false, replacedVarMap);
        }
        Set notNullVars = (Set)notNullVarsAndTopJoinRef.first;
        Mutable topJoinRef = (Mutable)notNullVarsAndTopJoinRef.second;
        ArrayList<Pair> groupByList = new ArrayList<Pair>();
        ArrayList<Pair> groupByDecorList = new ArrayList<Pair>();
        GroupByOperator groupbyOp = new GroupByOperator(groupByList, groupByDecorList, subplanOp.getNestedPlans());
        groupbyOp.setSourceLocation(sourceLoc);
        for (LogicalVariable coverVar : primaryKeyVars) {
            LogicalVariable newVar = context.newVar();
            VariableReferenceExpression coverVarRef = new VariableReferenceExpression(coverVar);
            coverVarRef.setSourceLocation(sourceLoc);
            groupByList.add(new Pair((Object)newVar, (Object)new MutableObject((Object)coverVarRef)));
            replacedVarMap.put(coverVar, newVar);
        }
        for (Object liveVar : liveVars) {
            if (primaryKeyVars.contains(liveVar)) continue;
            VariableReferenceExpression liveVarRef = new VariableReferenceExpression((LogicalVariable)liveVar);
            liveVarRef.setSourceLocation(sourceLoc);
            groupByDecorList.add(new Pair(null, (Object)new MutableObject((Object)liveVarRef)));
        }
        groupbyOp.getInputs().add(new MutableObject((Object)((ILogicalOperator)topJoinRef.getValue())));
        if (!notNullVars.isEmpty()) {
            Mutable selectExprRef;
            ArrayList<MutableObject> nullCheckExprRefs = new ArrayList<MutableObject>();
            for (LogicalVariable notNullVar : notNullVars) {
                VariableReferenceExpression notNullVarRef = new VariableReferenceExpression(notNullVar);
                notNullVarRef.setSourceLocation(sourceLoc);
                MutableObject filterVarExpr = new MutableObject((Object)notNullVarRef);
                ArrayList<MutableObject> args = new ArrayList<MutableObject>();
                args.add(filterVarExpr);
                ArrayList<MutableObject> argsForNotFunction = new ArrayList<MutableObject>();
                ScalarFunctionCallExpression isMissingExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)OperatorPropertiesUtil.getIsMissingNullFunction((IAlgebricksConstantValue)leftOuterMissingValue)), args);
                isMissingExpr.setSourceLocation(sourceLoc);
                argsForNotFunction.add(new MutableObject((Object)isMissingExpr));
                ScalarFunctionCallExpression notExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), argsForNotFunction);
                notExpr.setSourceLocation(sourceLoc);
                nullCheckExprRefs.add(new MutableObject((Object)notExpr));
            }
            if (nullCheckExprRefs.size() > 1) {
                ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), nullCheckExprRefs);
                andExpr.setSourceLocation(sourceLoc);
                selectExprRef = new MutableObject((Object)andExpr);
            } else {
                selectExprRef = (Mutable)nullCheckExprRefs.get(0);
            }
            SelectOperator selectOp = new SelectOperator(selectExprRef);
            selectOp.setSourceLocation(sourceLoc);
            topJoinRef.setValue((Object)selectOp);
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)groupbyOp));
            ntsOp.setSourceLocation(sourceLoc);
            selectOp.getInputs().add(new MutableObject((Object)ntsOp));
        } else {
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)groupbyOp));
            ntsOp.setSourceLocation(sourceLoc);
            topJoinRef.setValue((Object)ntsOp);
        }
        opRef.setValue((Object)groupbyOp);
        VariableUtilities.substituteVariables((ILogicalOperator)groupbyOp, (Map)((Map)result.second), (ITypingContext)context);
        OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)groupbyOp, (ITypingContext)context);
        replacedVarMap.putAll((Map)result.second);
        return new Pair((Object)true, replacedVarMap);
    }
}

