/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FactorRedundantGroupAndDecorVarsRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.GROUP) {
            return false;
        }
        GroupByOperator gby = (GroupByOperator)op;
        HashMap<LogicalVariable, LogicalVariable> varRhsToLhs = new HashMap<LogicalVariable, LogicalVariable>();
        boolean gvChanged = this.factorRedundantRhsVars(gby.getGroupByList(), opRef, varRhsToLhs, context);
        boolean dvChanged = this.factorRedundantRhsVars(gby.getDecorList(), opRef, varRhsToLhs, context);
        return gvChanged || dvChanged;
    }

    private boolean factorRedundantRhsVars(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> veList, Mutable<ILogicalOperator> opRef, Map<LogicalVariable, LogicalVariable> varRhsToLhs, IOptimizationContext context) throws AlgebricksException {
        varRhsToLhs.clear();
        ListIterator<Pair<LogicalVariable, Mutable<ILogicalExpression>>> iter = veList.listIterator();
        boolean changed = false;
        while (iter.hasNext()) {
            Pair<LogicalVariable, Mutable<ILogicalExpression>> p = iter.next();
            if (((ILogicalExpression)((Mutable)p.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            LogicalVariable v = GroupByOperator.getDecorVariable(p);
            LogicalVariable lhs = varRhsToLhs.get(v);
            if (lhs != null) {
                if (p.first != null) {
                    VariableReferenceExpression lhsRef = new VariableReferenceExpression(lhs);
                    SourceLocation sourceLoc = ((ILogicalExpression)((Mutable)p.second).getValue()).getSourceLocation();
                    lhsRef.setSourceLocation(sourceLoc);
                    AssignOperator assign = new AssignOperator((LogicalVariable)p.first, (Mutable)new MutableObject((Object)lhsRef));
                    assign.setSourceLocation(sourceLoc);
                    ILogicalOperator op = (ILogicalOperator)opRef.getValue();
                    assign.getInputs().add(new MutableObject((Object)op));
                    opRef.setValue((Object)assign);
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assign);
                }
                iter.remove();
                changed = true;
                continue;
            }
            varRhsToLhs.put(v, (LogicalVariable)p.first);
        }
        return changed;
    }
}

