/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import java.util.HashMap;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.AggregatePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.NestedPlansAccumulatingAggregatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.IWindowAggregatorDescriptor;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.dataflow.std.group.AbstractAccumulatingAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.AggregateState;

public final class WindowAggregatorDescriptorFactory
extends AbstractAccumulatingAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final AlgebricksPipeline[] subplans;
    private boolean partialOutputEnabled;

    public WindowAggregatorDescriptorFactory(AlgebricksPipeline[] subplans) {
        this.subplans = subplans;
    }

    public void setPartialOutputEnabled(boolean value) {
        this.partialOutputEnabled = value;
    }

    public IWindowAggregatorDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDescriptor, int[] keys, int[] partialKeys, long memoryBudget) throws HyracksDataException {
        final NestedPlansAccumulatingAggregatorFactory.AggregatorOutput outputWriter = new NestedPlansAccumulatingAggregatorFactory.AggregatorOutput(this.subplans, 0);
        final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] pipelines = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[this.subplans.length];
        HashMap<IPushRuntimeFactory, IPushRuntime> pipelineRuntimeMap = this.partialOutputEnabled ? new HashMap<IPushRuntimeFactory, IPushRuntime>() : null;
        final AggregatePushRuntime[] aggs = this.partialOutputEnabled ? new AggregatePushRuntime[this.subplans.length] : null;
        for (int i = 0; i < this.subplans.length; ++i) {
            AlgebricksPipeline subplan = this.subplans[i];
            if (pipelineRuntimeMap != null) {
                pipelineRuntimeMap.clear();
            }
            pipelines[i] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)PipelineAssembler.assemblePipeline(subplan, outputWriter, ctx, pipelineRuntimeMap);
            if (pipelineRuntimeMap == null) continue;
            IPushRuntimeFactory[] subplanFactories = subplan.getRuntimeFactories();
            IPushRuntimeFactory aggFactory = subplanFactories[subplanFactories.length - 1];
            AggregatePushRuntime agg = (AggregatePushRuntime)pipelineRuntimeMap.get(aggFactory);
            if (agg == null) {
                throw new IllegalStateException();
            }
            aggs[i] = agg;
        }
        return new IWindowAggregatorDescriptor(){

            public void init(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                outputWriter.getTupleBuilder().reset();
                for (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime pipeline : pipelines) {
                    pipeline.open();
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                this.memoryUsageCheck();
                for (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime pipeline : pipelines) {
                    pipeline.writeTuple(accessor.getBuffer(), tIndex);
                }
            }

            public boolean outputFinalResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor stateAccessor, int tIndex, AggregateState state) throws HyracksDataException {
                this.closePipelines();
                this.memoryUsageCheck();
                TupleUtils.addFields((ArrayTupleBuilder)outputWriter.getTupleBuilder(), (ArrayTupleBuilder)tupleBuilder);
                return true;
            }

            private void closePipelines() throws HyracksDataException {
                for (int i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].close();
                }
            }

            public boolean outputPartialResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                if (aggs == null) {
                    throw new UnsupportedOperationException();
                }
                for (int i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].flush();
                    aggs[i].finishAggregates(true);
                }
                this.memoryUsageCheck();
                TupleUtils.addFields((ArrayTupleBuilder)outputWriter.getTupleBuilder(), (ArrayTupleBuilder)tupleBuilder);
                outputWriter.getTupleBuilder().reset();
                return true;
            }

            @Override
            public void discardFinalResult() throws HyracksDataException {
                this.closePipelines();
            }

            public AggregateState createAggregateStates() {
                return null;
            }

            public void reset() {
            }

            public void close() {
            }

            private void memoryUsageCheck() {
            }
        };
    }
}

