/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.config;

import java.util.function.Function;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.config.SerializedOption;
import org.apache.hyracks.util.StringUtil;

public interface IOption {
    public String name();

    public Section section();

    public String description();

    public IOptionType type();

    public Object defaultValue();

    default public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
        return null;
    }

    default public Object get(IApplicationConfig appConfig) {
        return appConfig.getStatic(this);
    }

    default public boolean hidden() {
        return false;
    }

    default public String cmdline() {
        return "-" + this.name().toLowerCase().replace("_", "-");
    }

    default public String ini() {
        return IOption.toIni(this.name());
    }

    default public String camelCase() {
        return StringUtil.toCamelCase((String)this.name());
    }

    default public String toIniString() {
        return "[" + this.section().sectionName() + "] " + this.ini();
    }

    public static String toIni(String name) {
        return name.toLowerCase().replace("_", ".");
    }

    default public SerializedOption toSerializable() {
        return new SerializedOption(this);
    }
}

