/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.cache;

import java.util.concurrent.TimeUnit;
import org.apache.hyracks.util.cache.ICachePolicy;

public class TimeBasedCachePolicy
implements ICachePolicy {
    private final long expiryNanos;
    private long lastCacheTime;

    private TimeBasedCachePolicy(long expiryNanos) {
        this.expiryNanos = expiryNanos;
    }

    public static TimeBasedCachePolicy of(long value, TimeUnit unit) {
        return new TimeBasedCachePolicy(unit.toNanos(value));
    }

    @Override
    public synchronized boolean expired() {
        return System.nanoTime() - this.lastCacheTime >= this.expiryNanos;
    }

    @Override
    public synchronized void cached() {
        this.lastCacheTime = System.nanoTime();
    }
}

