/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.OGCStructure;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STGeomFromTextSRIDDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = STGeomFromTextSRIDDescriptor::new;
    private static final long serialVersionUID = 1L;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_GEOM_FROM_TEXT_SRID;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new STGeomFromTextSRIDEvaluator(args, ctx);
            }
        };
    }

    private class STGeomFromTextSRIDEvaluator
    implements IScalarEvaluator {
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg = new VoidPointable();
        private IScalarEvaluator eval;
        private IPointable inputArg0;
        private IScalarEvaluator eval0;
        private OperatorImportFromWkt wktImporter;

        public STGeomFromTextSRIDEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval = args[0].createScalarEvaluator(ctx);
            this.inputArg0 = new VoidPointable();
            this.eval0 = args[1].createScalarEvaluator(ctx);
            this.wktImporter = OperatorImportFromWkt.local();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.eval.evaluate(tuple, this.inputArg);
            byte[] data = this.inputArg.getByteArray();
            int offset = this.inputArg.getStartOffset();
            int len = this.inputArg.getLength();
            this.eval0.evaluate(tuple, this.inputArg0);
            byte[] data0 = this.inputArg0.getByteArray();
            int offset0 = this.inputArg0.getStartOffset();
            if (data[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(STGeomFromTextSRIDDescriptor.this.sourceLoc, STGeomFromTextSRIDDescriptor.this.getIdentifier(), 0, data[offset], new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG});
            }
            if (data0[offset0] != ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
                throw new TypeMismatchException(STGeomFromTextSRIDDescriptor.this.sourceLoc, STGeomFromTextSRIDDescriptor.this.getIdentifier(), 0, data0[offset0], new byte[]{ATypeTag.SERIALIZED_INT64_TYPE_TAG});
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(data, offset + 1, len - 1);
            DataInputStream dataIn = new DataInputStream(inStream);
            try {
                String geometry = AStringSerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn).getStringValue();
                int srid = (int)AInt64SerializerDeserializer.getLong((byte[])data0, (int)(offset0 + 1));
                OGCStructure structure = this.wktImporter.executeOGC(2, geometry, null);
                OGCGeometry ogcGeometry = OGCGeometry.createFromOGCStructure((OGCStructure)structure, (SpatialReference)SpatialReference.create((int)srid));
                ByteBuffer buffer = ogcGeometry.asBinary();
                byte[] wKBGeometryBuffer = buffer.array();
                this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                this.out.writeInt(wKBGeometryBuffer.length);
                this.out.write(wKBGeometryBuffer);
                result.set((IValueReference)this.resultStorage);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(STGeomFromTextSRIDDescriptor.this.sourceLoc, STGeomFromTextSRIDDescriptor.this.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
            }
        }
    }
}

