/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={AzureDataLakeStorageRestAPIImpl.class})
public final class AzureDataLakeStorageRestAPIImplBuilder {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final Map<String, String> properties = new HashMap<String, String>();
    private String url;
    private String resource;
    private String version;
    private String fileSystem;
    private String path;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;
    private HttpClient httpClient;
    private Configuration configuration;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();

    public AzureDataLakeStorageRestAPIImplBuilder url(String url) {
        this.url = url;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder resource(String resource) {
        this.resource = resource;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder fileSystem(String fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder path(String path) {
        this.path = path;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public AzureDataLakeStorageRestAPIImplBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public AzureDataLakeStorageRestAPIImpl buildClient() {
        if (this.resource == null) {
            this.resource = "filesystem";
        }
        if (this.version == null) {
            this.version = "2020-06-12";
        }
        if (this.pipeline == null) {
            this.pipeline = this.createHttpPipeline();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        AzureDataLakeStorageRestAPIImpl client = new AzureDataLakeStorageRestAPIImpl(this.pipeline, this.serializerAdapter, this.url, this.resource, this.version, this.fileSystem, this.path);
        return client;
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration;
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        policies.add(new CookiePolicy());
        policies.addAll(this.pipelinePolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return httpPipeline;
    }
}

